<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseQuotaExceededException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseQuotaExceededException
 * @subpackage Structs
 */
class LicenseQuotaExceededException extends InvalidUserLicenseException
{
    /**
     * The ConsumedLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConsumedLicenses;
    /**
     * The TotalLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalLicenses;
    /**
     * Constructor method for LicenseQuotaExceededException
     * @uses LicenseQuotaExceededException::setConsumedLicenses()
     * @uses LicenseQuotaExceededException::setTotalLicenses()
     * @param int $consumedLicenses
     * @param int $totalLicenses
     */
    public function __construct($consumedLicenses = null, $totalLicenses = null)
    {
        $this
            ->setConsumedLicenses($consumedLicenses)
            ->setTotalLicenses($totalLicenses);
    }
    /**
     * Get ConsumedLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConsumedLicenses()
    {
        return isset($this->ConsumedLicenses) ? $this->ConsumedLicenses : null;
    }
    /**
     * Set ConsumedLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $consumedLicenses
     * @return \StructType\LicenseQuotaExceededException
     */
    public function setConsumedLicenses($consumedLicenses = null)
    {
        // validation for constraint: int
        if (!is_null($consumedLicenses) && !is_numeric($consumedLicenses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consumedLicenses)), __LINE__);
        }
        if (is_null($consumedLicenses) || (is_array($consumedLicenses) && empty($consumedLicenses))) {
            unset($this->ConsumedLicenses);
        } else {
            $this->ConsumedLicenses = $consumedLicenses;
        }
        return $this;
    }
    /**
     * Get TotalLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalLicenses()
    {
        return isset($this->TotalLicenses) ? $this->TotalLicenses : null;
    }
    /**
     * Set TotalLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalLicenses
     * @return \StructType\LicenseQuotaExceededException
     */
    public function setTotalLicenses($totalLicenses = null)
    {
        // validation for constraint: int
        if (!is_null($totalLicenses) && !is_numeric($totalLicenses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalLicenses)), __LINE__);
        }
        if (is_null($totalLicenses) || (is_array($totalLicenses) && empty($totalLicenses))) {
            unset($this->TotalLicenses);
        } else {
            $this->TotalLicenses = $totalLicenses;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseQuotaExceededException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
