<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseErrorDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseErrorDetail
 * @subpackage Structs
 */
class LicenseErrorDetail extends AbstractStructBase
{
    /**
     * The DependsOnServicePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DependsOnServicePlans;
    /**
     * The ErrorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorType;
    /**
     * The IsWarning
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsWarning;
    /**
     * The ServicePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ServicePlans;
    /**
     * Constructor method for LicenseErrorDetail
     * @uses LicenseErrorDetail::setDependsOnServicePlans()
     * @uses LicenseErrorDetail::setErrorType()
     * @uses LicenseErrorDetail::setIsWarning()
     * @uses LicenseErrorDetail::setServicePlans()
     * @param \ArrayType\ArrayOfstring $dependsOnServicePlans
     * @param string $errorType
     * @param bool $isWarning
     * @param \ArrayType\ArrayOfstring $servicePlans
     */
    public function __construct(\ArrayType\ArrayOfstring $dependsOnServicePlans = null, $errorType = null, $isWarning = null, \ArrayType\ArrayOfstring $servicePlans = null)
    {
        $this
            ->setDependsOnServicePlans($dependsOnServicePlans)
            ->setErrorType($errorType)
            ->setIsWarning($isWarning)
            ->setServicePlans($servicePlans);
    }
    /**
     * Get DependsOnServicePlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDependsOnServicePlans()
    {
        return isset($this->DependsOnServicePlans) ? $this->DependsOnServicePlans : null;
    }
    /**
     * Set DependsOnServicePlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $dependsOnServicePlans
     * @return \StructType\LicenseErrorDetail
     */
    public function setDependsOnServicePlans(\ArrayType\ArrayOfstring $dependsOnServicePlans = null)
    {
        if (is_null($dependsOnServicePlans) || (is_array($dependsOnServicePlans) && empty($dependsOnServicePlans))) {
            unset($this->DependsOnServicePlans);
        } else {
            $this->DependsOnServicePlans = $dependsOnServicePlans;
        }
        return $this;
    }
    /**
     * Get ErrorType value
     * @return string|null
     */
    public function getErrorType()
    {
        return $this->ErrorType;
    }
    /**
     * Set ErrorType value
     * @uses \EnumType\LicenseErrorType::valueIsValid()
     * @uses \EnumType\LicenseErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorType
     * @return \StructType\LicenseErrorDetail
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LicenseErrorType::valueIsValid($errorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorType, implode(', ', \EnumType\LicenseErrorType::getValidValues())), __LINE__);
        }
        $this->ErrorType = $errorType;
        return $this;
    }
    /**
     * Get IsWarning value
     * @return bool|null
     */
    public function getIsWarning()
    {
        return $this->IsWarning;
    }
    /**
     * Set IsWarning value
     * @param bool $isWarning
     * @return \StructType\LicenseErrorDetail
     */
    public function setIsWarning($isWarning = null)
    {
        $this->IsWarning = $isWarning;
        return $this;
    }
    /**
     * Get ServicePlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getServicePlans()
    {
        return isset($this->ServicePlans) ? $this->ServicePlans : null;
    }
    /**
     * Set ServicePlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $servicePlans
     * @return \StructType\LicenseErrorDetail
     */
    public function setServicePlans(\ArrayType\ArrayOfstring $servicePlans = null)
    {
        if (is_null($servicePlans) || (is_array($servicePlans) && empty($servicePlans))) {
            unset($this->ServicePlans);
        } else {
            $this->ServicePlans = $servicePlans;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseErrorDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
