<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndirectLicenseError StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IndirectLicenseError
 * @subpackage Structs
 */
class IndirectLicenseError extends AbstractStructBase
{
    /**
     * The AccountSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSku;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The ReferencedObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedObjectId;
    /**
     * Constructor method for IndirectLicenseError
     * @uses IndirectLicenseError::setAccountSku()
     * @uses IndirectLicenseError::setError()
     * @uses IndirectLicenseError::setReferencedObjectId()
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @param string $error
     * @param string $referencedObjectId
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSku = null, $error = null, $referencedObjectId = null)
    {
        $this
            ->setAccountSku($accountSku)
            ->setError($error)
            ->setReferencedObjectId($referencedObjectId);
    }
    /**
     * Get AccountSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSku()
    {
        return isset($this->AccountSku) ? $this->AccountSku : null;
    }
    /**
     * Set AccountSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @return \StructType\IndirectLicenseError
     */
    public function setAccountSku(\StructType\AccountSkuIdentifier $accountSku = null)
    {
        if (is_null($accountSku) || (is_array($accountSku) && empty($accountSku))) {
            unset($this->AccountSku);
        } else {
            $this->AccountSku = $accountSku;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \StructType\IndirectLicenseError
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get ReferencedObjectId value
     * @return string|null
     */
    public function getReferencedObjectId()
    {
        return $this->ReferencedObjectId;
    }
    /**
     * Set ReferencedObjectId value
     * @param string $referencedObjectId
     * @return \StructType\IndirectLicenseError
     */
    public function setReferencedObjectId($referencedObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($referencedObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $referencedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($referencedObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referencedObjectId) && !is_string($referencedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referencedObjectId)), __LINE__);
        }
        $this->ReferencedObjectId = $referencedObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IndirectLicenseError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
