<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserByUpnRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUserByUpnRequest
 * @subpackage Structs
 */
class GetUserByUpnRequest extends Request
{
    /**
     * The ReturnDeletedUsers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnDeletedUsers;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for GetUserByUpnRequest
     * @uses GetUserByUpnRequest::setReturnDeletedUsers()
     * @uses GetUserByUpnRequest::setUserPrincipalName()
     * @param bool $returnDeletedUsers
     * @param string $userPrincipalName
     */
    public function __construct($returnDeletedUsers = null, $userPrincipalName = null)
    {
        $this
            ->setReturnDeletedUsers($returnDeletedUsers)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get ReturnDeletedUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnDeletedUsers()
    {
        return isset($this->ReturnDeletedUsers) ? $this->ReturnDeletedUsers : null;
    }
    /**
     * Set ReturnDeletedUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnDeletedUsers
     * @return \StructType\GetUserByUpnRequest
     */
    public function setReturnDeletedUsers($returnDeletedUsers = null)
    {
        if (is_null($returnDeletedUsers) || (is_array($returnDeletedUsers) && empty($returnDeletedUsers))) {
            unset($this->ReturnDeletedUsers);
        } else {
            $this->ReturnDeletedUsers = $returnDeletedUsers;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\GetUserByUpnRequest
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserByUpnRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
