<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSkuIdentifier StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountSkuIdentifier
 * @subpackage Structs
 */
class AccountSkuIdentifier extends AbstractStructBase
{
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The SkuPartNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SkuPartNumber;
    /**
     * Constructor method for AccountSkuIdentifier
     * @uses AccountSkuIdentifier::setAccountName()
     * @uses AccountSkuIdentifier::setSkuPartNumber()
     * @param string $accountName
     * @param string $skuPartNumber
     */
    public function __construct($accountName = null, $skuPartNumber = null)
    {
        $this
            ->setAccountName($accountName)
            ->setSkuPartNumber($skuPartNumber);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \StructType\AccountSkuIdentifier
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get SkuPartNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkuPartNumber()
    {
        return isset($this->SkuPartNumber) ? $this->SkuPartNumber : null;
    }
    /**
     * Set SkuPartNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skuPartNumber
     * @return \StructType\AccountSkuIdentifier
     */
    public function setSkuPartNumber($skuPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($skuPartNumber) && !is_string($skuPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($skuPartNumber)), __LINE__);
        }
        if (is_null($skuPartNumber) || (is_array($skuPartNumber) && empty($skuPartNumber))) {
            unset($this->SkuPartNumber);
        } else {
            $this->SkuPartNumber = $skuPartNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountSkuIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
