<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetHeaderInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHeaderInfo $parameters
     * @return \StructType\GetHeaderInfoResponse|bool
     */
    public function GetHeaderInfo(\StructType\GetHeaderInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHeaderInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceStatus $parameters
     * @return \StructType\GetServiceStatusResponse|bool
     */
    public function GetServiceStatus(\StructType\GetServiceStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPartnerInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPartnerInformation $parameters
     * @return \StructType\GetPartnerInformationResponse|bool
     */
    public function GetPartnerInformation(\StructType\GetPartnerInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPartnerInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdministrativeUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdministrativeUnit $parameters
     * @return \StructType\GetAdministrativeUnitResponse|bool
     */
    public function GetAdministrativeUnit(\StructType\GetAdministrativeUnit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAdministrativeUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyInformation $parameters
     * @return \StructType\GetCompanyInformationResponse|bool
     */
    public function GetCompanyInformation(\StructType\GetCompanyInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscription $parameters
     * @return \StructType\GetSubscriptionResponse|bool
     */
    public function GetSubscription(\StructType\GetSubscription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubscription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccidentalDeletionInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccidentalDeletionInformation $parameters
     * @return \StructType\GetAccidentalDeletionInformationResponse|bool
     */
    public function GetAccidentalDeletionInformation(\StructType\GetAccidentalDeletionInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccidentalDeletionInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyDirSyncFeatures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyDirSyncFeatures $parameters
     * @return \StructType\GetCompanyDirSyncFeaturesResponse|bool
     */
    public function GetCompanyDirSyncFeatures(\StructType\GetCompanyDirSyncFeatures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyDirSyncFeatures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPasswordPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPasswordPolicy $parameters
     * @return \StructType\GetPasswordPolicyResponse|bool
     */
    public function GetPasswordPolicy(\StructType\GetPasswordPolicy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPasswordPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyAllowedDataLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyAllowedDataLocation $parameters
     * @return \StructType\GetCompanyAllowedDataLocationResponse|bool
     */
    public function GetCompanyAllowedDataLocation(\StructType\GetCompanyAllowedDataLocation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyAllowedDataLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContact $parameters
     * @return \StructType\GetContactResponse|bool
     */
    public function GetContact(\StructType\GetContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDomainFederationSettings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDomainFederationSettings $parameters
     * @return \StructType\GetDomainFederationSettingsResponse|bool
     */
    public function GetDomainFederationSettings(\StructType\GetDomainFederationSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDomainFederationSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDomain $parameters
     * @return \StructType\GetDomainResponse|bool
     */
    public function GetDomain(\StructType\GetDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDomainVerificationDns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDomainVerificationDns $parameters
     * @return \StructType\GetDomainVerificationDnsResponse|bool
     */
    public function GetDomainVerificationDns(\StructType\GetDomainVerificationDns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDomainVerificationDns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroup $parameters
     * @return \StructType\GetGroupResponse|bool
     */
    public function GetGroup(\StructType\GetGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRole
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRole $parameters
     * @return \StructType\GetRoleResponse|bool
     */
    public function GetRole(\StructType\GetRole $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRole($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRoleByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRoleByName $parameters
     * @return \StructType\GetRoleByNameResponse|bool
     */
    public function GetRoleByName(\StructType\GetRoleByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRoleByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUser $parameters
     * @return \StructType\GetUserResponse|bool
     */
    public function GetUser(\StructType\GetUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserByUpn $parameters
     * @return \StructType\GetUserByUpnResponse|bool
     */
    public function GetUserByUpn(\StructType\GetUserByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByLiveId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserByLiveId $parameters
     * @return \StructType\GetUserByLiveIdResponse|bool
     */
    public function GetUserByLiveId(\StructType\GetUserByLiveId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByLiveId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServicePrincipal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePrincipal $parameters
     * @return \StructType\GetServicePrincipalResponse|bool
     */
    public function GetServicePrincipal(\StructType\GetServicePrincipal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServicePrincipal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetServicePrincipalByAppPrincipalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePrincipalByAppPrincipalId $parameters
     * @return \StructType\GetServicePrincipalByAppPrincipalIdResponse|bool
     */
    public function GetServicePrincipalByAppPrincipalId(\StructType\GetServicePrincipalByAppPrincipalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServicePrincipalByAppPrincipalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServicePrincipalBySpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePrincipalBySpn $parameters
     * @return \StructType\GetServicePrincipalBySpnResponse|bool
     */
    public function GetServicePrincipalBySpn(\StructType\GetServicePrincipalBySpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServicePrincipalBySpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccidentalDeletionInformationResponse|\StructType\GetAdministrativeUnitResponse|\StructType\GetCompanyAllowedDataLocationResponse|\StructType\GetCompanyDirSyncFeaturesResponse|\StructType\GetCompanyInformationResponse|\StructType\GetContactResponse|\StructType\GetDomainFederationSettingsResponse|\StructType\GetDomainResponse|\StructType\GetDomainVerificationDnsResponse|\StructType\GetGroupResponse|\StructType\GetHeaderInfoResponse|\StructType\GetPartnerInformationResponse|\StructType\GetPasswordPolicyResponse|\StructType\GetRoleByNameResponse|\StructType\GetRoleResponse|\StructType\GetServicePrincipalByAppPrincipalIdResponse|\StructType\GetServicePrincipalBySpnResponse|\StructType\GetServicePrincipalResponse|\StructType\GetServiceStatusResponse|\StructType\GetSubscriptionResponse|\StructType\GetUserByLiveIdResponse|\StructType\GetUserByUpnResponse|\StructType\GetUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
