<?php

namespace EnumType;

/**
 * This class stands for UserType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UserType
 * @subpackage Enumerations
 */
class UserType
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Member'
     * @return string 'Member'
     */
    const VALUE_MEMBER = 'Member';
    /**
     * Constant for value 'Guest'
     * @return string 'Guest'
     */
    const VALUE_GUEST = 'Guest';
    /**
     * Constant for value 'Viral'
     * @return string 'Viral'
     */
    const VALUE_VIRAL = 'Viral';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_MEMBER
     * @uses self::VALUE_GUEST
     * @uses self::VALUE_VIRAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_MEMBER,
            self::VALUE_GUEST,
            self::VALUE_VIRAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
