<?php

namespace EnumType;

/**
 * This class stands for UserEnabledFilter EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UserEnabledFilter
 * @subpackage Enumerations
 */
class UserEnabledFilter
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'EnabledOnly'
     * @return string 'EnabledOnly'
     */
    const VALUE_ENABLED_ONLY = 'EnabledOnly';
    /**
     * Constant for value 'DisabledOnly'
     * @return string 'DisabledOnly'
     */
    const VALUE_DISABLED_ONLY = 'DisabledOnly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ENABLED_ONLY
     * @uses self::VALUE_DISABLED_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ENABLED_ONLY,
            self::VALUE_DISABLED_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
