<?php

namespace EnumType;

/**
 * This class stands for O365TenantReleaseTrack EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:O365TenantReleaseTrack
 * @subpackage Enumerations
 */
class O365TenantReleaseTrack
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'FirstRelease'
     * @return string 'FirstRelease'
     */
    const VALUE_FIRST_RELEASE = 'FirstRelease';
    /**
     * Constant for value 'StagedRollout'
     * @return string 'StagedRollout'
     */
    const VALUE_STAGED_ROLLOUT = 'StagedRollout';
    /**
     * Constant for value 'Dogfood'
     * @return string 'Dogfood'
     */
    const VALUE_DOGFOOD = 'Dogfood';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_FIRST_RELEASE
     * @uses self::VALUE_STAGED_ROLLOUT
     * @uses self::VALUE_DOGFOOD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_FIRST_RELEASE,
            self::VALUE_STAGED_ROLLOUT,
            self::VALUE_DOGFOOD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
