<?php

namespace EnumType;

/**
 * This class stands for CompanyType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CompanyType
 * @subpackage Enumerations
 */
class CompanyType
{
    /**
     * Constant for value 'CompanyTenant'
     * @return string 'CompanyTenant'
     */
    const VALUE_COMPANY_TENANT = 'CompanyTenant';
    /**
     * Constant for value 'MicrosoftSupportTenant'
     * @return string 'MicrosoftSupportTenant'
     */
    const VALUE_MICROSOFT_SUPPORT_TENANT = 'MicrosoftSupportTenant';
    /**
     * Constant for value 'SyndicatePartnerTenant'
     * @return string 'SyndicatePartnerTenant'
     */
    const VALUE_SYNDICATE_PARTNER_TENANT = 'SyndicatePartnerTenant';
    /**
     * Constant for value 'SupportPartnerTenant'
     * @return string 'SupportPartnerTenant'
     */
    const VALUE_SUPPORT_PARTNER_TENANT = 'SupportPartnerTenant';
    /**
     * Constant for value 'ResellerPartnerTenant'
     * @return string 'ResellerPartnerTenant'
     */
    const VALUE_RESELLER_PARTNER_TENANT = 'ResellerPartnerTenant';
    /**
     * Constant for value 'ValueAddedResellerPartnerTenant'
     * @return string 'ValueAddedResellerPartnerTenant'
     */
    const VALUE_VALUE_ADDED_RESELLER_PARTNER_TENANT = 'ValueAddedResellerPartnerTenant';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPANY_TENANT
     * @uses self::VALUE_MICROSOFT_SUPPORT_TENANT
     * @uses self::VALUE_SYNDICATE_PARTNER_TENANT
     * @uses self::VALUE_SUPPORT_PARTNER_TENANT
     * @uses self::VALUE_RESELLER_PARTNER_TENANT
     * @uses self::VALUE_VALUE_ADDED_RESELLER_PARTNER_TENANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPANY_TENANT,
            self::VALUE_MICROSOFT_SUPPORT_TENANT,
            self::VALUE_SYNDICATE_PARTNER_TENANT,
            self::VALUE_SUPPORT_PARTNER_TENANT,
            self::VALUE_RESELLER_PARTNER_TENANT,
            self::VALUE_VALUE_ADDED_RESELLER_PARTNER_TENANT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
