<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicePrincipal ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServicePrincipal
 * @subpackage Arrays
 */
class ArrayOfServicePrincipal extends AbstractStructArrayBase
{
    /**
     * The ServicePrincipal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServicePrincipal[]
     */
    public $ServicePrincipal;
    /**
     * Constructor method for ArrayOfServicePrincipal
     * @uses ArrayOfServicePrincipal::setServicePrincipal()
     * @param \StructType\ServicePrincipal[] $servicePrincipal
     */
    public function __construct(array $servicePrincipal = array())
    {
        $this
            ->setServicePrincipal($servicePrincipal);
    }
    /**
     * Get ServicePrincipal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServicePrincipal[]|null
     */
    public function getServicePrincipal()
    {
        return isset($this->ServicePrincipal) ? $this->ServicePrincipal : null;
    }
    /**
     * Set ServicePrincipal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServicePrincipal[] $servicePrincipal
     * @return \ArrayType\ArrayOfServicePrincipal
     */
    public function setServicePrincipal(array $servicePrincipal = array())
    {
        foreach ($servicePrincipal as $arrayOfServicePrincipalServicePrincipalItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicePrincipalServicePrincipalItem instanceof \StructType\ServicePrincipal) {
                throw new \InvalidArgumentException(sprintf('The ServicePrincipal property can only contain items of \StructType\ServicePrincipal, "%s" given', is_object($arrayOfServicePrincipalServicePrincipalItem) ? get_class($arrayOfServicePrincipalServicePrincipalItem) : gettype($arrayOfServicePrincipalServicePrincipalItem)), __LINE__);
            }
        }
        if (is_null($servicePrincipal) || (is_array($servicePrincipal) && empty($servicePrincipal))) {
            unset($this->ServicePrincipal);
        } else {
            $this->ServicePrincipal = $servicePrincipal;
        }
        return $this;
    }
    /**
     * Add item to ServicePrincipal value
     * @throws \InvalidArgumentException
     * @param \StructType\ServicePrincipal $item
     * @return \ArrayType\ArrayOfServicePrincipal
     */
    public function addToServicePrincipal(\StructType\ServicePrincipal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServicePrincipal) {
            throw new \InvalidArgumentException(sprintf('The ServicePrincipal property can only contain items of \StructType\ServicePrincipal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicePrincipal[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServicePrincipal|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServicePrincipal|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServicePrincipal|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServicePrincipal|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServicePrincipal|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicePrincipal
     */
    public function getAttributeName()
    {
        return 'ServicePrincipal';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfServicePrincipal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
