<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoleScopedMember ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoleScopedMember
 * @subpackage Arrays
 */
class ArrayOfRoleScopedMember extends AbstractStructArrayBase
{
    /**
     * The RoleScopedMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RoleScopedMember[]
     */
    public $RoleScopedMember;
    /**
     * Constructor method for ArrayOfRoleScopedMember
     * @uses ArrayOfRoleScopedMember::setRoleScopedMember()
     * @param \StructType\RoleScopedMember[] $roleScopedMember
     */
    public function __construct(array $roleScopedMember = array())
    {
        $this
            ->setRoleScopedMember($roleScopedMember);
    }
    /**
     * Get RoleScopedMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RoleScopedMember[]|null
     */
    public function getRoleScopedMember()
    {
        return isset($this->RoleScopedMember) ? $this->RoleScopedMember : null;
    }
    /**
     * Set RoleScopedMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RoleScopedMember[] $roleScopedMember
     * @return \ArrayType\ArrayOfRoleScopedMember
     */
    public function setRoleScopedMember(array $roleScopedMember = array())
    {
        foreach ($roleScopedMember as $arrayOfRoleScopedMemberRoleScopedMemberItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoleScopedMemberRoleScopedMemberItem instanceof \StructType\RoleScopedMember) {
                throw new \InvalidArgumentException(sprintf('The RoleScopedMember property can only contain items of \StructType\RoleScopedMember, "%s" given', is_object($arrayOfRoleScopedMemberRoleScopedMemberItem) ? get_class($arrayOfRoleScopedMemberRoleScopedMemberItem) : gettype($arrayOfRoleScopedMemberRoleScopedMemberItem)), __LINE__);
            }
        }
        if (is_null($roleScopedMember) || (is_array($roleScopedMember) && empty($roleScopedMember))) {
            unset($this->RoleScopedMember);
        } else {
            $this->RoleScopedMember = $roleScopedMember;
        }
        return $this;
    }
    /**
     * Add item to RoleScopedMember value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleScopedMember $item
     * @return \ArrayType\ArrayOfRoleScopedMember
     */
    public function addToRoleScopedMember(\StructType\RoleScopedMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleScopedMember) {
            throw new \InvalidArgumentException(sprintf('The RoleScopedMember property can only contain items of \StructType\RoleScopedMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoleScopedMember[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoleScopedMember|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoleScopedMember|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoleScopedMember|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoleScopedMember|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoleScopedMember|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoleScopedMember
     */
    public function getAttributeName()
    {
        return 'RoleScopedMember';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRoleScopedMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
