<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRedirectUri ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRedirectUri
 * @subpackage Arrays
 */
class ArrayOfRedirectUri extends AbstractStructArrayBase
{
    /**
     * The RedirectUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedirectUri[]
     */
    public $RedirectUri;
    /**
     * Constructor method for ArrayOfRedirectUri
     * @uses ArrayOfRedirectUri::setRedirectUri()
     * @param \StructType\RedirectUri[] $redirectUri
     */
    public function __construct(array $redirectUri = array())
    {
        $this
            ->setRedirectUri($redirectUri);
    }
    /**
     * Get RedirectUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedirectUri[]|null
     */
    public function getRedirectUri()
    {
        return isset($this->RedirectUri) ? $this->RedirectUri : null;
    }
    /**
     * Set RedirectUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RedirectUri[] $redirectUri
     * @return \ArrayType\ArrayOfRedirectUri
     */
    public function setRedirectUri(array $redirectUri = array())
    {
        foreach ($redirectUri as $arrayOfRedirectUriRedirectUriItem) {
            // validation for constraint: itemType
            if (!$arrayOfRedirectUriRedirectUriItem instanceof \StructType\RedirectUri) {
                throw new \InvalidArgumentException(sprintf('The RedirectUri property can only contain items of \StructType\RedirectUri, "%s" given', is_object($arrayOfRedirectUriRedirectUriItem) ? get_class($arrayOfRedirectUriRedirectUriItem) : gettype($arrayOfRedirectUriRedirectUriItem)), __LINE__);
            }
        }
        if (is_null($redirectUri) || (is_array($redirectUri) && empty($redirectUri))) {
            unset($this->RedirectUri);
        } else {
            $this->RedirectUri = $redirectUri;
        }
        return $this;
    }
    /**
     * Add item to RedirectUri value
     * @throws \InvalidArgumentException
     * @param \StructType\RedirectUri $item
     * @return \ArrayType\ArrayOfRedirectUri
     */
    public function addToRedirectUri(\StructType\RedirectUri $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RedirectUri) {
            throw new \InvalidArgumentException(sprintf('The RedirectUri property can only contain items of \StructType\RedirectUri, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RedirectUri[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RedirectUri|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RedirectUri|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RedirectUri|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RedirectUri|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RedirectUri|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RedirectUri
     */
    public function getAttributeName()
    {
        return 'RedirectUri';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRedirectUri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
