<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLicenseOption ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLicenseOption
 * @subpackage Arrays
 */
class ArrayOfLicenseOption extends AbstractStructArrayBase
{
    /**
     * The LicenseOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LicenseOption[]
     */
    public $LicenseOption;
    /**
     * Constructor method for ArrayOfLicenseOption
     * @uses ArrayOfLicenseOption::setLicenseOption()
     * @param \StructType\LicenseOption[] $licenseOption
     */
    public function __construct(array $licenseOption = array())
    {
        $this
            ->setLicenseOption($licenseOption);
    }
    /**
     * Get LicenseOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LicenseOption[]|null
     */
    public function getLicenseOption()
    {
        return isset($this->LicenseOption) ? $this->LicenseOption : null;
    }
    /**
     * Set LicenseOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LicenseOption[] $licenseOption
     * @return \ArrayType\ArrayOfLicenseOption
     */
    public function setLicenseOption(array $licenseOption = array())
    {
        foreach ($licenseOption as $arrayOfLicenseOptionLicenseOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfLicenseOptionLicenseOptionItem instanceof \StructType\LicenseOption) {
                throw new \InvalidArgumentException(sprintf('The LicenseOption property can only contain items of \StructType\LicenseOption, "%s" given', is_object($arrayOfLicenseOptionLicenseOptionItem) ? get_class($arrayOfLicenseOptionLicenseOptionItem) : gettype($arrayOfLicenseOptionLicenseOptionItem)), __LINE__);
            }
        }
        if (is_null($licenseOption) || (is_array($licenseOption) && empty($licenseOption))) {
            unset($this->LicenseOption);
        } else {
            $this->LicenseOption = $licenseOption;
        }
        return $this;
    }
    /**
     * Add item to LicenseOption value
     * @throws \InvalidArgumentException
     * @param \StructType\LicenseOption $item
     * @return \ArrayType\ArrayOfLicenseOption
     */
    public function addToLicenseOption(\StructType\LicenseOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LicenseOption) {
            throw new \InvalidArgumentException(sprintf('The LicenseOption property can only contain items of \StructType\LicenseOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LicenseOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LicenseOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LicenseOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LicenseOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LicenseOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LicenseOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LicenseOption
     */
    public function getAttributeName()
    {
        return 'LicenseOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLicenseOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
