<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupMember ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGroupMember
 * @subpackage Arrays
 */
class ArrayOfGroupMember extends AbstractStructArrayBase
{
    /**
     * The GroupMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupMember[]
     */
    public $GroupMember;
    /**
     * Constructor method for ArrayOfGroupMember
     * @uses ArrayOfGroupMember::setGroupMember()
     * @param \StructType\GroupMember[] $groupMember
     */
    public function __construct(array $groupMember = array())
    {
        $this
            ->setGroupMember($groupMember);
    }
    /**
     * Get GroupMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupMember[]|null
     */
    public function getGroupMember()
    {
        return isset($this->GroupMember) ? $this->GroupMember : null;
    }
    /**
     * Set GroupMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupMember[] $groupMember
     * @return \ArrayType\ArrayOfGroupMember
     */
    public function setGroupMember(array $groupMember = array())
    {
        foreach ($groupMember as $arrayOfGroupMemberGroupMemberItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupMemberGroupMemberItem instanceof \StructType\GroupMember) {
                throw new \InvalidArgumentException(sprintf('The GroupMember property can only contain items of \StructType\GroupMember, "%s" given', is_object($arrayOfGroupMemberGroupMemberItem) ? get_class($arrayOfGroupMemberGroupMemberItem) : gettype($arrayOfGroupMemberGroupMemberItem)), __LINE__);
            }
        }
        if (is_null($groupMember) || (is_array($groupMember) && empty($groupMember))) {
            unset($this->GroupMember);
        } else {
            $this->GroupMember = $groupMember;
        }
        return $this;
    }
    /**
     * Add item to GroupMember value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupMember $item
     * @return \ArrayType\ArrayOfGroupMember
     */
    public function addToGroupMember(\StructType\GroupMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupMember) {
            throw new \InvalidArgumentException(sprintf('The GroupMember property can only contain items of \StructType\GroupMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupMember[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupMember|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupMember|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupMember|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupMember|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupMember|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupMember
     */
    public function getAttributeName()
    {
        return 'GroupMember';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
