<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAssignedLicense ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAssignedLicense
 * @subpackage Arrays
 */
class ArrayOfAssignedLicense extends AbstractStructArrayBase
{
    /**
     * The AssignedLicense
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssignedLicense[]
     */
    public $AssignedLicense;
    /**
     * Constructor method for ArrayOfAssignedLicense
     * @uses ArrayOfAssignedLicense::setAssignedLicense()
     * @param \StructType\AssignedLicense[] $assignedLicense
     */
    public function __construct(array $assignedLicense = array())
    {
        $this
            ->setAssignedLicense($assignedLicense);
    }
    /**
     * Get AssignedLicense value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssignedLicense[]|null
     */
    public function getAssignedLicense()
    {
        return isset($this->AssignedLicense) ? $this->AssignedLicense : null;
    }
    /**
     * Set AssignedLicense value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedLicense[] $assignedLicense
     * @return \ArrayType\ArrayOfAssignedLicense
     */
    public function setAssignedLicense(array $assignedLicense = array())
    {
        foreach ($assignedLicense as $arrayOfAssignedLicenseAssignedLicenseItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssignedLicenseAssignedLicenseItem instanceof \StructType\AssignedLicense) {
                throw new \InvalidArgumentException(sprintf('The AssignedLicense property can only contain items of \StructType\AssignedLicense, "%s" given', is_object($arrayOfAssignedLicenseAssignedLicenseItem) ? get_class($arrayOfAssignedLicenseAssignedLicenseItem) : gettype($arrayOfAssignedLicenseAssignedLicenseItem)), __LINE__);
            }
        }
        if (is_null($assignedLicense) || (is_array($assignedLicense) && empty($assignedLicense))) {
            unset($this->AssignedLicense);
        } else {
            $this->AssignedLicense = $assignedLicense;
        }
        return $this;
    }
    /**
     * Add item to AssignedLicense value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedLicense $item
     * @return \ArrayType\ArrayOfAssignedLicense
     */
    public function addToAssignedLicense(\StructType\AssignedLicense $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedLicense) {
            throw new \InvalidArgumentException(sprintf('The AssignedLicense property can only contain items of \StructType\AssignedLicense, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AssignedLicense[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AssignedLicense|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AssignedLicense|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AssignedLicense|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AssignedLicense|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AssignedLicense|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AssignedLicense
     */
    public function getAttributeName()
    {
        return 'AssignedLicense';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAssignedLicense
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
