<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengersLog StructType
 * @subpackage Structs
 */
class PassengersLog extends AbstractStructBase
{
    /**
     * The regId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The p_doorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $p_doorId;
    /**
     * The p_ingresos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $p_ingresos;
    /**
     * The p_salidas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $p_salidas;
    /**
     * The p_bloqueos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $p_bloqueos;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The p_station
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $p_station;
    /**
     * The p_total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $p_total;
    /**
     * The gps_UTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gps_UTC;
    /**
     * The system_UTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_UTC;
    /**
     * Constructor method for PassengersLog
     * @uses PassengersLog::setRegId()
     * @uses PassengersLog::setP_doorId()
     * @uses PassengersLog::setP_ingresos()
     * @uses PassengersLog::setP_salidas()
     * @uses PassengersLog::setP_bloqueos()
     * @uses PassengersLog::setMId()
     * @uses PassengersLog::setP_station()
     * @uses PassengersLog::setP_total()
     * @uses PassengersLog::setGps_UTC()
     * @uses PassengersLog::setSystem_UTC()
     * @param int $regId
     * @param int $p_doorId
     * @param int $p_ingresos
     * @param int $p_salidas
     * @param int $p_bloqueos
     * @param string $mId
     * @param string $p_station
     * @param string $p_total
     * @param string $gps_UTC
     * @param string $system_UTC
     */
    public function __construct($regId = null, $p_doorId = null, $p_ingresos = null, $p_salidas = null, $p_bloqueos = null, $mId = null, $p_station = null, $p_total = null, $gps_UTC = null, $system_UTC = null)
    {
        $this
            ->setRegId($regId)
            ->setP_doorId($p_doorId)
            ->setP_ingresos($p_ingresos)
            ->setP_salidas($p_salidas)
            ->setP_bloqueos($p_bloqueos)
            ->setMId($mId)
            ->setP_station($p_station)
            ->setP_total($p_total)
            ->setGps_UTC($gps_UTC)
            ->setSystem_UTC($system_UTC);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\PassengersLog
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get p_doorId value
     * @return int
     */
    public function getP_doorId()
    {
        return $this->p_doorId;
    }
    /**
     * Set p_doorId value
     * @param int $p_doorId
     * @return \StructType\PassengersLog
     */
    public function setP_doorId($p_doorId = null)
    {
        // validation for constraint: int
        if (!is_null($p_doorId) && !(is_int($p_doorId) || ctype_digit($p_doorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p_doorId, true), gettype($p_doorId)), __LINE__);
        }
        $this->p_doorId = $p_doorId;
        return $this;
    }
    /**
     * Get p_ingresos value
     * @return int
     */
    public function getP_ingresos()
    {
        return $this->p_ingresos;
    }
    /**
     * Set p_ingresos value
     * @param int $p_ingresos
     * @return \StructType\PassengersLog
     */
    public function setP_ingresos($p_ingresos = null)
    {
        // validation for constraint: int
        if (!is_null($p_ingresos) && !(is_int($p_ingresos) || ctype_digit($p_ingresos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p_ingresos, true), gettype($p_ingresos)), __LINE__);
        }
        $this->p_ingresos = $p_ingresos;
        return $this;
    }
    /**
     * Get p_salidas value
     * @return int
     */
    public function getP_salidas()
    {
        return $this->p_salidas;
    }
    /**
     * Set p_salidas value
     * @param int $p_salidas
     * @return \StructType\PassengersLog
     */
    public function setP_salidas($p_salidas = null)
    {
        // validation for constraint: int
        if (!is_null($p_salidas) && !(is_int($p_salidas) || ctype_digit($p_salidas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p_salidas, true), gettype($p_salidas)), __LINE__);
        }
        $this->p_salidas = $p_salidas;
        return $this;
    }
    /**
     * Get p_bloqueos value
     * @return int
     */
    public function getP_bloqueos()
    {
        return $this->p_bloqueos;
    }
    /**
     * Set p_bloqueos value
     * @param int $p_bloqueos
     * @return \StructType\PassengersLog
     */
    public function setP_bloqueos($p_bloqueos = null)
    {
        // validation for constraint: int
        if (!is_null($p_bloqueos) && !(is_int($p_bloqueos) || ctype_digit($p_bloqueos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p_bloqueos, true), gettype($p_bloqueos)), __LINE__);
        }
        $this->p_bloqueos = $p_bloqueos;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\PassengersLog
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get p_station value
     * @return string|null
     */
    public function getP_station()
    {
        return $this->p_station;
    }
    /**
     * Set p_station value
     * @param string $p_station
     * @return \StructType\PassengersLog
     */
    public function setP_station($p_station = null)
    {
        // validation for constraint: string
        if (!is_null($p_station) && !is_string($p_station)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($p_station, true), gettype($p_station)), __LINE__);
        }
        $this->p_station = $p_station;
        return $this;
    }
    /**
     * Get p_total value
     * @return string|null
     */
    public function getP_total()
    {
        return $this->p_total;
    }
    /**
     * Set p_total value
     * @param string $p_total
     * @return \StructType\PassengersLog
     */
    public function setP_total($p_total = null)
    {
        // validation for constraint: string
        if (!is_null($p_total) && !is_string($p_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($p_total, true), gettype($p_total)), __LINE__);
        }
        $this->p_total = $p_total;
        return $this;
    }
    /**
     * Get gps_UTC value
     * @return string|null
     */
    public function getGps_UTC()
    {
        return $this->gps_UTC;
    }
    /**
     * Set gps_UTC value
     * @param string $gps_UTC
     * @return \StructType\PassengersLog
     */
    public function setGps_UTC($gps_UTC = null)
    {
        // validation for constraint: string
        if (!is_null($gps_UTC) && !is_string($gps_UTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_UTC, true), gettype($gps_UTC)), __LINE__);
        }
        $this->gps_UTC = $gps_UTC;
        return $this;
    }
    /**
     * Get system_UTC value
     * @return string|null
     */
    public function getSystem_UTC()
    {
        return $this->system_UTC;
    }
    /**
     * Set system_UTC value
     * @param string $system_UTC
     * @return \StructType\PassengersLog
     */
    public function setSystem_UTC($system_UTC = null)
    {
        // validation for constraint: string
        if (!is_null($system_UTC) && !is_string($system_UTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_UTC, true), gettype($system_UTC)), __LINE__);
        }
        $this->system_UTC = $system_UTC;
        return $this;
    }
}
