<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeolocatedPassengerLog StructType
 * @subpackage Structs
 */
class GeolocatedPassengerLog extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The blocking_count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $blocking_count;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The driver_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $driver_id;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The gps_time
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gps_time;
    /**
     * The system_time
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_time;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The doors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDoor
     */
    public $doors;
    /**
     * The driver_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driver_name;
    /**
     * The driver_document
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driver_document;
    /**
     * Constructor method for GeolocatedPassengerLog
     * @uses GeolocatedPassengerLog::setId()
     * @uses GeolocatedPassengerLog::setBlocking_count()
     * @uses GeolocatedPassengerLog::setLatitude()
     * @uses GeolocatedPassengerLog::setLongitude()
     * @uses GeolocatedPassengerLog::setDriver_id()
     * @uses GeolocatedPassengerLog::setMId()
     * @uses GeolocatedPassengerLog::setGps_time()
     * @uses GeolocatedPassengerLog::setSystem_time()
     * @uses GeolocatedPassengerLog::setAddress()
     * @uses GeolocatedPassengerLog::setDoors()
     * @uses GeolocatedPassengerLog::setDriver_name()
     * @uses GeolocatedPassengerLog::setDriver_document()
     * @param int $id
     * @param int $blocking_count
     * @param float $latitude
     * @param float $longitude
     * @param int $driver_id
     * @param string $mId
     * @param string $gps_time
     * @param string $system_time
     * @param string $address
     * @param \ArrayType\ArrayOfDoor $doors
     * @param string $driver_name
     * @param string $driver_document
     */
    public function __construct($id = null, $blocking_count = null, $latitude = null, $longitude = null, $driver_id = null, $mId = null, $gps_time = null, $system_time = null, $address = null, \ArrayType\ArrayOfDoor $doors = null, $driver_name = null, $driver_document = null)
    {
        $this
            ->setId($id)
            ->setBlocking_count($blocking_count)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setDriver_id($driver_id)
            ->setMId($mId)
            ->setGps_time($gps_time)
            ->setSystem_time($system_time)
            ->setAddress($address)
            ->setDoors($doors)
            ->setDriver_name($driver_name)
            ->setDriver_document($driver_document);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get blocking_count value
     * @return int
     */
    public function getBlocking_count()
    {
        return $this->blocking_count;
    }
    /**
     * Set blocking_count value
     * @param int $blocking_count
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setBlocking_count($blocking_count = null)
    {
        // validation for constraint: int
        if (!is_null($blocking_count) && !(is_int($blocking_count) || ctype_digit($blocking_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blocking_count, true), gettype($blocking_count)), __LINE__);
        }
        $this->blocking_count = $blocking_count;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get driver_id value
     * @return int
     */
    public function getDriver_id()
    {
        return $this->driver_id;
    }
    /**
     * Set driver_id value
     * @param int $driver_id
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setDriver_id($driver_id = null)
    {
        // validation for constraint: int
        if (!is_null($driver_id) && !(is_int($driver_id) || ctype_digit($driver_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driver_id, true), gettype($driver_id)), __LINE__);
        }
        $this->driver_id = $driver_id;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get gps_time value
     * @return string|null
     */
    public function getGps_time()
    {
        return $this->gps_time;
    }
    /**
     * Set gps_time value
     * @param string $gps_time
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setGps_time($gps_time = null)
    {
        // validation for constraint: string
        if (!is_null($gps_time) && !is_string($gps_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_time, true), gettype($gps_time)), __LINE__);
        }
        $this->gps_time = $gps_time;
        return $this;
    }
    /**
     * Get system_time value
     * @return string|null
     */
    public function getSystem_time()
    {
        return $this->system_time;
    }
    /**
     * Set system_time value
     * @param string $system_time
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setSystem_time($system_time = null)
    {
        // validation for constraint: string
        if (!is_null($system_time) && !is_string($system_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_time, true), gettype($system_time)), __LINE__);
        }
        $this->system_time = $system_time;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get doors value
     * @return \ArrayType\ArrayOfDoor|null
     */
    public function getDoors()
    {
        return $this->doors;
    }
    /**
     * Set doors value
     * @param \ArrayType\ArrayOfDoor $doors
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setDoors(\ArrayType\ArrayOfDoor $doors = null)
    {
        $this->doors = $doors;
        return $this;
    }
    /**
     * Get driver_name value
     * @return string|null
     */
    public function getDriver_name()
    {
        return $this->driver_name;
    }
    /**
     * Set driver_name value
     * @param string $driver_name
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setDriver_name($driver_name = null)
    {
        // validation for constraint: string
        if (!is_null($driver_name) && !is_string($driver_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver_name, true), gettype($driver_name)), __LINE__);
        }
        $this->driver_name = $driver_name;
        return $this;
    }
    /**
     * Get driver_document value
     * @return string|null
     */
    public function getDriver_document()
    {
        return $this->driver_document;
    }
    /**
     * Set driver_document value
     * @param string $driver_document
     * @return \StructType\GeolocatedPassengerLog
     */
    public function setDriver_document($driver_document = null)
    {
        // validation for constraint: string
        if (!is_null($driver_document) && !is_string($driver_document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver_document, true), gettype($driver_document)), __LINE__);
        }
        $this->driver_document = $driver_document;
        return $this;
    }
}
