<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackerEvent StructType
 * @subpackage Structs
 */
class TrackerEvent extends AbstractStructBase
{
    /**
     * The regId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EntityType;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EventType;
    /**
     * The RoadSpeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoadSpeed;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Altitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Altitude;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Speed;
    /**
     * The Precision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Precision;
    /**
     * The Heading
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Heading;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Age;
    /**
     * The LimitExceeded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LimitExceeded;
    /**
     * The DriverId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DriverId;
    /**
     * The TrackerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackerId;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityId;
    /**
     * The GpsGMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsGMT;
    /**
     * The SystemGMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemGMT;
    /**
     * The eventDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $eventDescription;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Poi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Poi;
    /**
     * The DriverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverName;
    /**
     * The Itineraries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventItinery
     */
    public $Itineraries;
    /**
     * Constructor method for TrackerEvent
     * @uses TrackerEvent::setRegId()
     * @uses TrackerEvent::setEntityType()
     * @uses TrackerEvent::setEventType()
     * @uses TrackerEvent::setRoadSpeed()
     * @uses TrackerEvent::setLatitude()
     * @uses TrackerEvent::setLongitude()
     * @uses TrackerEvent::setAltitude()
     * @uses TrackerEvent::setSpeed()
     * @uses TrackerEvent::setPrecision()
     * @uses TrackerEvent::setHeading()
     * @uses TrackerEvent::setAge()
     * @uses TrackerEvent::setLimitExceeded()
     * @uses TrackerEvent::setDriverId()
     * @uses TrackerEvent::setTrackerId()
     * @uses TrackerEvent::setEntityId()
     * @uses TrackerEvent::setGpsGMT()
     * @uses TrackerEvent::setSystemGMT()
     * @uses TrackerEvent::setEventDescription()
     * @uses TrackerEvent::setAddress()
     * @uses TrackerEvent::setPoi()
     * @uses TrackerEvent::setDriverName()
     * @uses TrackerEvent::setItineraries()
     * @param int $regId
     * @param int $entityType
     * @param int $eventType
     * @param int $roadSpeed
     * @param float $latitude
     * @param float $longitude
     * @param int $altitude
     * @param int $speed
     * @param int $precision
     * @param int $heading
     * @param int $age
     * @param int $limitExceeded
     * @param int $driverId
     * @param string $trackerId
     * @param string $entityId
     * @param string $gpsGMT
     * @param string $systemGMT
     * @param string $eventDescription
     * @param string $address
     * @param string $poi
     * @param string $driverName
     * @param \ArrayType\ArrayOfEventItinery $itineraries
     */
    public function __construct($regId = null, $entityType = null, $eventType = null, $roadSpeed = null, $latitude = null, $longitude = null, $altitude = null, $speed = null, $precision = null, $heading = null, $age = null, $limitExceeded = null, $driverId = null, $trackerId = null, $entityId = null, $gpsGMT = null, $systemGMT = null, $eventDescription = null, $address = null, $poi = null, $driverName = null, \ArrayType\ArrayOfEventItinery $itineraries = null)
    {
        $this
            ->setRegId($regId)
            ->setEntityType($entityType)
            ->setEventType($eventType)
            ->setRoadSpeed($roadSpeed)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude)
            ->setSpeed($speed)
            ->setPrecision($precision)
            ->setHeading($heading)
            ->setAge($age)
            ->setLimitExceeded($limitExceeded)
            ->setDriverId($driverId)
            ->setTrackerId($trackerId)
            ->setEntityId($entityId)
            ->setGpsGMT($gpsGMT)
            ->setSystemGMT($systemGMT)
            ->setEventDescription($eventDescription)
            ->setAddress($address)
            ->setPoi($poi)
            ->setDriverName($driverName)
            ->setItineraries($itineraries);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\TrackerEvent
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get EntityType value
     * @return int
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @param int $entityType
     * @return \StructType\TrackerEvent
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: int
        if (!is_null($entityType) && !(is_int($entityType) || ctype_digit($entityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get EventType value
     * @return int
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @param int $eventType
     * @return \StructType\TrackerEvent
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: int
        if (!is_null($eventType) && !(is_int($eventType) || ctype_digit($eventType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get RoadSpeed value
     * @return int
     */
    public function getRoadSpeed()
    {
        return $this->RoadSpeed;
    }
    /**
     * Set RoadSpeed value
     * @param int $roadSpeed
     * @return \StructType\TrackerEvent
     */
    public function setRoadSpeed($roadSpeed = null)
    {
        // validation for constraint: int
        if (!is_null($roadSpeed) && !(is_int($roadSpeed) || ctype_digit($roadSpeed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roadSpeed, true), gettype($roadSpeed)), __LINE__);
        }
        $this->RoadSpeed = $roadSpeed;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\TrackerEvent
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\TrackerEvent
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return int
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param int $altitude
     * @return \StructType\TrackerEvent
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: int
        if (!is_null($altitude) && !(is_int($altitude) || ctype_digit($altitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Get Speed value
     * @return int
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\TrackerEvent
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get Precision value
     * @return int
     */
    public function getPrecision()
    {
        return $this->Precision;
    }
    /**
     * Set Precision value
     * @param int $precision
     * @return \StructType\TrackerEvent
     */
    public function setPrecision($precision = null)
    {
        // validation for constraint: int
        if (!is_null($precision) && !(is_int($precision) || ctype_digit($precision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($precision, true), gettype($precision)), __LINE__);
        }
        $this->Precision = $precision;
        return $this;
    }
    /**
     * Get Heading value
     * @return int
     */
    public function getHeading()
    {
        return $this->Heading;
    }
    /**
     * Set Heading value
     * @param int $heading
     * @return \StructType\TrackerEvent
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: int
        if (!is_null($heading) && !(is_int($heading) || ctype_digit($heading))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heading, true), gettype($heading)), __LINE__);
        }
        $this->Heading = $heading;
        return $this;
    }
    /**
     * Get Age value
     * @return int
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\TrackerEvent
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get LimitExceeded value
     * @return int
     */
    public function getLimitExceeded()
    {
        return $this->LimitExceeded;
    }
    /**
     * Set LimitExceeded value
     * @param int $limitExceeded
     * @return \StructType\TrackerEvent
     */
    public function setLimitExceeded($limitExceeded = null)
    {
        // validation for constraint: int
        if (!is_null($limitExceeded) && !(is_int($limitExceeded) || ctype_digit($limitExceeded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limitExceeded, true), gettype($limitExceeded)), __LINE__);
        }
        $this->LimitExceeded = $limitExceeded;
        return $this;
    }
    /**
     * Get DriverId value
     * @return int
     */
    public function getDriverId()
    {
        return $this->DriverId;
    }
    /**
     * Set DriverId value
     * @param int $driverId
     * @return \StructType\TrackerEvent
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: int
        if (!is_null($driverId) && !(is_int($driverId) || ctype_digit($driverId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverId, true), gettype($driverId)), __LINE__);
        }
        $this->DriverId = $driverId;
        return $this;
    }
    /**
     * Get TrackerId value
     * @return string|null
     */
    public function getTrackerId()
    {
        return $this->TrackerId;
    }
    /**
     * Set TrackerId value
     * @param string $trackerId
     * @return \StructType\TrackerEvent
     */
    public function setTrackerId($trackerId = null)
    {
        // validation for constraint: string
        if (!is_null($trackerId) && !is_string($trackerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackerId, true), gettype($trackerId)), __LINE__);
        }
        $this->TrackerId = $trackerId;
        return $this;
    }
    /**
     * Get EntityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \StructType\TrackerEvent
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get GpsGMT value
     * @return string|null
     */
    public function getGpsGMT()
    {
        return $this->GpsGMT;
    }
    /**
     * Set GpsGMT value
     * @param string $gpsGMT
     * @return \StructType\TrackerEvent
     */
    public function setGpsGMT($gpsGMT = null)
    {
        // validation for constraint: string
        if (!is_null($gpsGMT) && !is_string($gpsGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gpsGMT, true), gettype($gpsGMT)), __LINE__);
        }
        $this->GpsGMT = $gpsGMT;
        return $this;
    }
    /**
     * Get SystemGMT value
     * @return string|null
     */
    public function getSystemGMT()
    {
        return $this->SystemGMT;
    }
    /**
     * Set SystemGMT value
     * @param string $systemGMT
     * @return \StructType\TrackerEvent
     */
    public function setSystemGMT($systemGMT = null)
    {
        // validation for constraint: string
        if (!is_null($systemGMT) && !is_string($systemGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemGMT, true), gettype($systemGMT)), __LINE__);
        }
        $this->SystemGMT = $systemGMT;
        return $this;
    }
    /**
     * Get eventDescription value
     * @return string|null
     */
    public function getEventDescription()
    {
        return $this->eventDescription;
    }
    /**
     * Set eventDescription value
     * @param string $eventDescription
     * @return \StructType\TrackerEvent
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        $this->eventDescription = $eventDescription;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\TrackerEvent
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Poi value
     * @return string|null
     */
    public function getPoi()
    {
        return $this->Poi;
    }
    /**
     * Set Poi value
     * @param string $poi
     * @return \StructType\TrackerEvent
     */
    public function setPoi($poi = null)
    {
        // validation for constraint: string
        if (!is_null($poi) && !is_string($poi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poi, true), gettype($poi)), __LINE__);
        }
        $this->Poi = $poi;
        return $this;
    }
    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }
    /**
     * Set DriverName value
     * @param string $driverName
     * @return \StructType\TrackerEvent
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }
    /**
     * Get Itineraries value
     * @return \ArrayType\ArrayOfEventItinery|null
     */
    public function getItineraries()
    {
        return $this->Itineraries;
    }
    /**
     * Set Itineraries value
     * @param \ArrayType\ArrayOfEventItinery $itineraries
     * @return \StructType\TrackerEvent
     */
    public function setItineraries(\ArrayType\ArrayOfEventItinery $itineraries = null)
    {
        $this->Itineraries = $itineraries;
        return $this;
    }
}
