<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_Fleet StructType
 * @subpackage Structs
 */
class Payments_Fleet extends AbstractStructBase
{
    /**
     * The FleetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FleetId;
    /**
     * The FleetName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FleetName;
    /**
     * Constructor method for Payments_Fleet
     * @uses Payments_Fleet::setFleetId()
     * @uses Payments_Fleet::setFleetName()
     * @param int $fleetId
     * @param string $fleetName
     */
    public function __construct($fleetId = null, $fleetName = null)
    {
        $this
            ->setFleetId($fleetId)
            ->setFleetName($fleetName);
    }
    /**
     * Get FleetId value
     * @return int
     */
    public function getFleetId()
    {
        return $this->FleetId;
    }
    /**
     * Set FleetId value
     * @param int $fleetId
     * @return \StructType\Payments_Fleet
     */
    public function setFleetId($fleetId = null)
    {
        // validation for constraint: int
        if (!is_null($fleetId) && !(is_int($fleetId) || ctype_digit($fleetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fleetId, true), gettype($fleetId)), __LINE__);
        }
        $this->FleetId = $fleetId;
        return $this;
    }
    /**
     * Get FleetName value
     * @return string|null
     */
    public function getFleetName()
    {
        return $this->FleetName;
    }
    /**
     * Set FleetName value
     * @param string $fleetName
     * @return \StructType\Payments_Fleet
     */
    public function setFleetName($fleetName = null)
    {
        // validation for constraint: string
        if (!is_null($fleetName) && !is_string($fleetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fleetName, true), gettype($fleetName)), __LINE__);
        }
        $this->FleetName = $fleetName;
        return $this;
    }
}
