<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItPoint StructType
 * @subpackage Structs
 */
class ItPoint extends AbstractStructBase
{
    /**
     * The point_index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $point_index;
    /**
     * The geofence_index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $geofence_index;
    /**
     * The time_min
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $time_min;
    /**
     * The time_max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $time_max;
    /**
     * The print
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $print;
    /**
     * The geofence_name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geofence_name;
    /**
     * Constructor method for ItPoint
     * @uses ItPoint::setPoint_index()
     * @uses ItPoint::setGeofence_index()
     * @uses ItPoint::setTime_min()
     * @uses ItPoint::setTime_max()
     * @uses ItPoint::setPrint()
     * @uses ItPoint::setGeofence_name()
     * @param int $point_index
     * @param int $geofence_index
     * @param int $time_min
     * @param int $time_max
     * @param int $print
     * @param string $geofence_name
     */
    public function __construct($point_index = null, $geofence_index = null, $time_min = null, $time_max = null, $print = null, $geofence_name = null)
    {
        $this
            ->setPoint_index($point_index)
            ->setGeofence_index($geofence_index)
            ->setTime_min($time_min)
            ->setTime_max($time_max)
            ->setPrint($print)
            ->setGeofence_name($geofence_name);
    }
    /**
     * Get point_index value
     * @return int
     */
    public function getPoint_index()
    {
        return $this->point_index;
    }
    /**
     * Set point_index value
     * @param int $point_index
     * @return \StructType\ItPoint
     */
    public function setPoint_index($point_index = null)
    {
        // validation for constraint: int
        if (!is_null($point_index) && !(is_int($point_index) || ctype_digit($point_index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($point_index, true), gettype($point_index)), __LINE__);
        }
        $this->point_index = $point_index;
        return $this;
    }
    /**
     * Get geofence_index value
     * @return int
     */
    public function getGeofence_index()
    {
        return $this->geofence_index;
    }
    /**
     * Set geofence_index value
     * @param int $geofence_index
     * @return \StructType\ItPoint
     */
    public function setGeofence_index($geofence_index = null)
    {
        // validation for constraint: int
        if (!is_null($geofence_index) && !(is_int($geofence_index) || ctype_digit($geofence_index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geofence_index, true), gettype($geofence_index)), __LINE__);
        }
        $this->geofence_index = $geofence_index;
        return $this;
    }
    /**
     * Get time_min value
     * @return int
     */
    public function getTime_min()
    {
        return $this->time_min;
    }
    /**
     * Set time_min value
     * @param int $time_min
     * @return \StructType\ItPoint
     */
    public function setTime_min($time_min = null)
    {
        // validation for constraint: int
        if (!is_null($time_min) && !(is_int($time_min) || ctype_digit($time_min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($time_min, true), gettype($time_min)), __LINE__);
        }
        $this->time_min = $time_min;
        return $this;
    }
    /**
     * Get time_max value
     * @return int
     */
    public function getTime_max()
    {
        return $this->time_max;
    }
    /**
     * Set time_max value
     * @param int $time_max
     * @return \StructType\ItPoint
     */
    public function setTime_max($time_max = null)
    {
        // validation for constraint: int
        if (!is_null($time_max) && !(is_int($time_max) || ctype_digit($time_max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($time_max, true), gettype($time_max)), __LINE__);
        }
        $this->time_max = $time_max;
        return $this;
    }
    /**
     * Get print value
     * @return int
     */
    public function getPrint()
    {
        return $this->print;
    }
    /**
     * Set print value
     * @param int $print
     * @return \StructType\ItPoint
     */
    public function setPrint($print = null)
    {
        // validation for constraint: int
        if (!is_null($print) && !(is_int($print) || ctype_digit($print))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($print, true), gettype($print)), __LINE__);
        }
        $this->print = $print;
        return $this;
    }
    /**
     * Get geofence_name value
     * @return string|null
     */
    public function getGeofence_name()
    {
        return $this->geofence_name;
    }
    /**
     * Set geofence_name value
     * @param string $geofence_name
     * @return \StructType\ItPoint
     */
    public function setGeofence_name($geofence_name = null)
    {
        // validation for constraint: string
        if (!is_null($geofence_name) && !is_string($geofence_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geofence_name, true), gettype($geofence_name)), __LINE__);
        }
        $this->geofence_name = $geofence_name;
        return $this;
    }
}
