<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Horometer StructType
 * @subpackage Structs
 */
class Horometer extends AbstractStructBase
{
    /**
     * The HoroCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HoroCount;
    /**
     * The Tracker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tracker;
    /**
     * The LastHoroDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastHoroDateTime;
    /**
     * Constructor method for Horometer
     * @uses Horometer::setHoroCount()
     * @uses Horometer::setTracker()
     * @uses Horometer::setLastHoroDateTime()
     * @param int $horoCount
     * @param string $tracker
     * @param string $lastHoroDateTime
     */
    public function __construct($horoCount = null, $tracker = null, $lastHoroDateTime = null)
    {
        $this
            ->setHoroCount($horoCount)
            ->setTracker($tracker)
            ->setLastHoroDateTime($lastHoroDateTime);
    }
    /**
     * Get HoroCount value
     * @return int
     */
    public function getHoroCount()
    {
        return $this->HoroCount;
    }
    /**
     * Set HoroCount value
     * @param int $horoCount
     * @return \StructType\Horometer
     */
    public function setHoroCount($horoCount = null)
    {
        // validation for constraint: int
        if (!is_null($horoCount) && !(is_int($horoCount) || ctype_digit($horoCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($horoCount, true), gettype($horoCount)), __LINE__);
        }
        $this->HoroCount = $horoCount;
        return $this;
    }
    /**
     * Get Tracker value
     * @return string|null
     */
    public function getTracker()
    {
        return $this->Tracker;
    }
    /**
     * Set Tracker value
     * @param string $tracker
     * @return \StructType\Horometer
     */
    public function setTracker($tracker = null)
    {
        // validation for constraint: string
        if (!is_null($tracker) && !is_string($tracker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracker, true), gettype($tracker)), __LINE__);
        }
        $this->Tracker = $tracker;
        return $this;
    }
    /**
     * Get LastHoroDateTime value
     * @return string|null
     */
    public function getLastHoroDateTime()
    {
        return $this->LastHoroDateTime;
    }
    /**
     * Set LastHoroDateTime value
     * @param string $lastHoroDateTime
     * @return \StructType\Horometer
     */
    public function setLastHoroDateTime($lastHoroDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastHoroDateTime) && !is_string($lastHoroDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastHoroDateTime, true), gettype($lastHoroDateTime)), __LINE__);
        }
        $this->LastHoroDateTime = $lastHoroDateTime;
        return $this;
    }
}
