<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETQ ServiceType
 * @subpackage Services
 */
class GETQ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_QuickMessageLog
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el listado de los mensajes rápidos que se han recibido de un movil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_QuickMessageLog $parameters
     * @return \StructType\GET_QuickMessageLogResponse|bool
     */
    public function GET_QuickMessageLog(\StructType\GET_QuickMessageLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_QuickMessageLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_QuickMessageLogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
