<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETL ServiceType
 * @subpackage Services
 */
class GETL extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_LastLocation
     * Meta information extracted from the WSDL
     * - documentation: Devuelve la última posición reportada por un móvil.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_LastLocation $parameters
     * @return \StructType\GET_LastLocationResponse|bool
     */
    public function GET_LastLocation(\StructType\GET_LastLocation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_LastLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_LastLocation_Fleet
     * Meta information extracted from the WSDL
     * - documentation: Devuelve la última posición de los moviles de una flota.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_LastLocation_Fleet $parameters
     * @return \StructType\GET_LastLocation_FleetResponse|bool
     */
    public function GET_LastLocation_Fleet(\StructType\GET_LastLocation_Fleet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_LastLocation_Fleet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_LastLocationByPlate
     * Meta information extracted from the WSDL
     * - documentation: Devuelve la última posición reportada por un móvil ingresando la placa.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_LastLocationByPlate $parameters
     * @return \StructType\GET_LastLocationByPlateResponse|bool
     */
    public function GET_LastLocationByPlate(\StructType\GET_LastLocationByPlate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_LastLocationByPlate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_LastLocationByPlateResponse|\StructType\GET_LastLocationResponse|\StructType\GET_LastLocation_FleetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
