<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETT ServiceType
 * @subpackage Services
 */
class GETT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_TrackerOdometer
     * Meta information extracted from the WSDL
     * - documentation: Retorna el valor y última fecha de actualización del odómetro de un Móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerOdometer $parameters
     * @return \StructType\GET_TrackerOdometerResponse|bool
     */
    public function GET_TrackerOdometer(\StructType\GET_TrackerOdometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerOdometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TrackerEventsHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de eventos de un tracker. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerEventsHistory $parameters
     * @return \StructType\GET_TrackerEventsHistoryResponse|bool
     */
    public function GET_TrackerEventsHistory(\StructType\GET_TrackerEventsHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerEventsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TripsAndPassengersSummary
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el total de viajes y pasajeros de un vehículo dentro de un rango de fechas. UTC_datetime_Init y UTC_datetime_End se da en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TripsAndPassengersSummary $parameters
     * @return \StructType\GET_TripsAndPassengersSummaryResponse|bool
     */
    public function GET_TripsAndPassengersSummary(\StructType\GET_TripsAndPassengersSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TripsAndPassengersSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TripsAndPassengersByMId
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el total de viajes y pasajeros de un vehículo dentro de un rango de fechas. UTC_datetime_Init y UTC_datetime_End se da en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TripsAndPassengersByMId $parameters
     * @return \StructType\GET_TripsAndPassengersByMIdResponse|bool
     */
    public function GET_TripsAndPassengersByMId(\StructType\GET_TripsAndPassengersByMId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TripsAndPassengersByMId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TrackerHorometer
     * Meta information extracted from the WSDL
     * - documentation: Retorna el valor y última fecha de actualización del Horómetro de un Móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerHorometer $parameters
     * @return \StructType\GET_TrackerHorometerResponse|bool
     */
    public function GET_TrackerHorometer(\StructType\GET_TrackerHorometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerHorometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_TrackerEventsHistoryResponse|\StructType\GET_TrackerHorometerResponse|\StructType\GET_TrackerOdometerResponse|\StructType\GET_TripsAndPassengersByMIdResponse|\StructType\GET_TripsAndPassengersSummaryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
