<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileinfoWithSpecs_Response StructType
 * @subpackage Structs
 */
class MobileinfoWithSpecs_Response extends AbstractStructBase
{
    /**
     * The error_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The mobileInfoWithspecs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MobileInfoWithSpecs
     */
    public $mobileInfoWithspecs;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for MobileinfoWithSpecs_Response
     * @uses MobileinfoWithSpecs_Response::setError_code()
     * @uses MobileinfoWithSpecs_Response::setMobileInfoWithspecs()
     * @uses MobileinfoWithSpecs_Response::setStatus()
     * @uses MobileinfoWithSpecs_Response::setDescription()
     * @param int $error_code
     * @param \StructType\MobileInfoWithSpecs $mobileInfoWithspecs
     * @param string $status
     * @param string $description
     */
    public function __construct($error_code = null, \StructType\MobileInfoWithSpecs $mobileInfoWithspecs = null, $status = null, $description = null)
    {
        $this
            ->setError_code($error_code)
            ->setMobileInfoWithspecs($mobileInfoWithspecs)
            ->setStatus($status)
            ->setDescription($description);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\MobileinfoWithSpecs_Response
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get mobileInfoWithspecs value
     * @return \StructType\MobileInfoWithSpecs
     */
    public function getMobileInfoWithspecs()
    {
        return $this->mobileInfoWithspecs;
    }
    /**
     * Set mobileInfoWithspecs value
     * @param \StructType\MobileInfoWithSpecs $mobileInfoWithspecs
     * @return \StructType\MobileinfoWithSpecs_Response
     */
    public function setMobileInfoWithspecs(\StructType\MobileInfoWithSpecs $mobileInfoWithspecs = null)
    {
        $this->mobileInfoWithspecs = $mobileInfoWithspecs;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\MobileinfoWithSpecs_Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MobileinfoWithSpecs_Response
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
