<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_ADAS_events_totals StructType
 * @subpackage Structs
 */
class Get_ADAS_events_totals extends AbstractStructBase
{
    /**
     * The fleet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $fleet;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The mIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mIds;
    /**
     * The spns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $spns;
    /**
     * The UTC_datetime_init
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UTC_datetime_init;
    /**
     * The UTC_datetime_end
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UTC_datetime_end;
    /**
     * Constructor method for Get_ADAS_events_totals
     * @uses Get_ADAS_events_totals::setFleet()
     * @uses Get_ADAS_events_totals::setUser()
     * @uses Get_ADAS_events_totals::setPassword()
     * @uses Get_ADAS_events_totals::setMIds()
     * @uses Get_ADAS_events_totals::setSpns()
     * @uses Get_ADAS_events_totals::setUTC_datetime_init()
     * @uses Get_ADAS_events_totals::setUTC_datetime_end()
     * @param int $fleet
     * @param string $user
     * @param string $password
     * @param string $mIds
     * @param string $spns
     * @param string $uTC_datetime_init
     * @param string $uTC_datetime_end
     */
    public function __construct($fleet = null, $user = null, $password = null, $mIds = null, $spns = null, $uTC_datetime_init = null, $uTC_datetime_end = null)
    {
        $this
            ->setFleet($fleet)
            ->setUser($user)
            ->setPassword($password)
            ->setMIds($mIds)
            ->setSpns($spns)
            ->setUTC_datetime_init($uTC_datetime_init)
            ->setUTC_datetime_end($uTC_datetime_end);
    }
    /**
     * Get fleet value
     * @return int
     */
    public function getFleet()
    {
        return $this->fleet;
    }
    /**
     * Set fleet value
     * @param int $fleet
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setFleet($fleet = null)
    {
        // validation for constraint: int
        if (!is_null($fleet) && !(is_int($fleet) || ctype_digit($fleet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fleet, true), gettype($fleet)), __LINE__);
        }
        $this->fleet = $fleet;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get mIds value
     * @return string|null
     */
    public function getMIds()
    {
        return $this->mIds;
    }
    /**
     * Set mIds value
     * @param string $mIds
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setMIds($mIds = null)
    {
        // validation for constraint: string
        if (!is_null($mIds) && !is_string($mIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIds, true), gettype($mIds)), __LINE__);
        }
        $this->mIds = $mIds;
        return $this;
    }
    /**
     * Get spns value
     * @return string|null
     */
    public function getSpns()
    {
        return $this->spns;
    }
    /**
     * Set spns value
     * @param string $spns
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setSpns($spns = null)
    {
        // validation for constraint: string
        if (!is_null($spns) && !is_string($spns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spns, true), gettype($spns)), __LINE__);
        }
        $this->spns = $spns;
        return $this;
    }
    /**
     * Get UTC_datetime_init value
     * @return string|null
     */
    public function getUTC_datetime_init()
    {
        return $this->UTC_datetime_init;
    }
    /**
     * Set UTC_datetime_init value
     * @param string $uTC_datetime_init
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setUTC_datetime_init($uTC_datetime_init = null)
    {
        // validation for constraint: string
        if (!is_null($uTC_datetime_init) && !is_string($uTC_datetime_init)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTC_datetime_init, true), gettype($uTC_datetime_init)), __LINE__);
        }
        $this->UTC_datetime_init = $uTC_datetime_init;
        return $this;
    }
    /**
     * Get UTC_datetime_end value
     * @return string|null
     */
    public function getUTC_datetime_end()
    {
        return $this->UTC_datetime_end;
    }
    /**
     * Set UTC_datetime_end value
     * @param string $uTC_datetime_end
     * @return \StructType\Get_ADAS_events_totals
     */
    public function setUTC_datetime_end($uTC_datetime_end = null)
    {
        // validation for constraint: string
        if (!is_null($uTC_datetime_end) && !is_string($uTC_datetime_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTC_datetime_end, true), gettype($uTC_datetime_end)), __LINE__);
        }
        $this->UTC_datetime_end = $uTC_datetime_end;
        return $this;
    }
}
