<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ADASspnTotals StructType
 * @subpackage Structs
 */
class ADASspnTotals extends AbstractStructBase
{
    /**
     * The spnTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $spnTotal;
    /**
     * The spnName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $spnName;
    /**
     * Constructor method for ADASspnTotals
     * @uses ADASspnTotals::setSpnTotal()
     * @uses ADASspnTotals::setSpnName()
     * @param int $spnTotal
     * @param string $spnName
     */
    public function __construct($spnTotal = null, $spnName = null)
    {
        $this
            ->setSpnTotal($spnTotal)
            ->setSpnName($spnName);
    }
    /**
     * Get spnTotal value
     * @return int
     */
    public function getSpnTotal()
    {
        return $this->spnTotal;
    }
    /**
     * Set spnTotal value
     * @param int $spnTotal
     * @return \StructType\ADASspnTotals
     */
    public function setSpnTotal($spnTotal = null)
    {
        // validation for constraint: int
        if (!is_null($spnTotal) && !(is_int($spnTotal) || ctype_digit($spnTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($spnTotal, true), gettype($spnTotal)), __LINE__);
        }
        $this->spnTotal = $spnTotal;
        return $this;
    }
    /**
     * Get spnName value
     * @return string|null
     */
    public function getSpnName()
    {
        return $this->spnName;
    }
    /**
     * Set spnName value
     * @param string $spnName
     * @return \StructType\ADASspnTotals
     */
    public function setSpnName($spnName = null)
    {
        // validation for constraint: string
        if (!is_null($spnName) && !is_string($spnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spnName, true), gettype($spnName)), __LINE__);
        }
        $this->spnName = $spnName;
        return $this;
    }
}
