<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETE ServiceType
 * @subpackage Services
 */
class GETE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_EventsHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de eventos de un móvil. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_EventsHistory $parameters
     * @return \StructType\GET_EventsHistoryResponse|bool
     */
    public function GET_EventsHistory(\StructType\GET_EventsHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_EventsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_EndedItinerariesHistory
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el historial de los itinerarios que se hayan terminado en el rango de tiempo especificado por UTC_datetime_init y UTC_datetime_end. UTC_datetime_init y UTC_datetime_end se dan en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_EndedItinerariesHistory $parameters
     * @return \StructType\GET_EndedItinerariesHistoryResponse|bool
     */
    public function GET_EndedItinerariesHistory(\StructType\GET_EndedItinerariesHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_EndedItinerariesHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_EndedItinerariesHistoryResponse|\StructType\GET_EventsHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
