<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripsAndPcounter StructType
 * @subpackage Structs
 */
class TripsAndPcounter extends AbstractStructBase
{
    /**
     * The mobilizedPassengers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mobilizedPassengers;
    /**
     * The georeferencedPassengers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $georeferencedPassengers;
    /**
     * The passengersDifference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $passengersDifference;
    /**
     * The driverDoc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $driverDoc;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The mDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mDescription;
    /**
     * The dateTimeInit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateTimeInit;
    /**
     * The dateTimeEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateTimeEnd;
    /**
     * The driverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverName;
    /**
     * The itDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $itDesc;
    /**
     * Constructor method for TripsAndPcounter
     * @uses TripsAndPcounter::setMobilizedPassengers()
     * @uses TripsAndPcounter::setGeoreferencedPassengers()
     * @uses TripsAndPcounter::setPassengersDifference()
     * @uses TripsAndPcounter::setDriverDoc()
     * @uses TripsAndPcounter::setMId()
     * @uses TripsAndPcounter::setMDescription()
     * @uses TripsAndPcounter::setDateTimeInit()
     * @uses TripsAndPcounter::setDateTimeEnd()
     * @uses TripsAndPcounter::setDriverName()
     * @uses TripsAndPcounter::setItDesc()
     * @param int $mobilizedPassengers
     * @param int $georeferencedPassengers
     * @param int $passengersDifference
     * @param int $driverDoc
     * @param string $mId
     * @param string $mDescription
     * @param string $dateTimeInit
     * @param string $dateTimeEnd
     * @param string $driverName
     * @param string $itDesc
     */
    public function __construct($mobilizedPassengers = null, $georeferencedPassengers = null, $passengersDifference = null, $driverDoc = null, $mId = null, $mDescription = null, $dateTimeInit = null, $dateTimeEnd = null, $driverName = null, $itDesc = null)
    {
        $this
            ->setMobilizedPassengers($mobilizedPassengers)
            ->setGeoreferencedPassengers($georeferencedPassengers)
            ->setPassengersDifference($passengersDifference)
            ->setDriverDoc($driverDoc)
            ->setMId($mId)
            ->setMDescription($mDescription)
            ->setDateTimeInit($dateTimeInit)
            ->setDateTimeEnd($dateTimeEnd)
            ->setDriverName($driverName)
            ->setItDesc($itDesc);
    }
    /**
     * Get mobilizedPassengers value
     * @return int
     */
    public function getMobilizedPassengers()
    {
        return $this->mobilizedPassengers;
    }
    /**
     * Set mobilizedPassengers value
     * @param int $mobilizedPassengers
     * @return \StructType\TripsAndPcounter
     */
    public function setMobilizedPassengers($mobilizedPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($mobilizedPassengers) && !(is_int($mobilizedPassengers) || ctype_digit($mobilizedPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mobilizedPassengers, true), gettype($mobilizedPassengers)), __LINE__);
        }
        $this->mobilizedPassengers = $mobilizedPassengers;
        return $this;
    }
    /**
     * Get georeferencedPassengers value
     * @return int
     */
    public function getGeoreferencedPassengers()
    {
        return $this->georeferencedPassengers;
    }
    /**
     * Set georeferencedPassengers value
     * @param int $georeferencedPassengers
     * @return \StructType\TripsAndPcounter
     */
    public function setGeoreferencedPassengers($georeferencedPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($georeferencedPassengers) && !(is_int($georeferencedPassengers) || ctype_digit($georeferencedPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($georeferencedPassengers, true), gettype($georeferencedPassengers)), __LINE__);
        }
        $this->georeferencedPassengers = $georeferencedPassengers;
        return $this;
    }
    /**
     * Get passengersDifference value
     * @return int
     */
    public function getPassengersDifference()
    {
        return $this->passengersDifference;
    }
    /**
     * Set passengersDifference value
     * @param int $passengersDifference
     * @return \StructType\TripsAndPcounter
     */
    public function setPassengersDifference($passengersDifference = null)
    {
        // validation for constraint: int
        if (!is_null($passengersDifference) && !(is_int($passengersDifference) || ctype_digit($passengersDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengersDifference, true), gettype($passengersDifference)), __LINE__);
        }
        $this->passengersDifference = $passengersDifference;
        return $this;
    }
    /**
     * Get driverDoc value
     * @return int
     */
    public function getDriverDoc()
    {
        return $this->driverDoc;
    }
    /**
     * Set driverDoc value
     * @param int $driverDoc
     * @return \StructType\TripsAndPcounter
     */
    public function setDriverDoc($driverDoc = null)
    {
        // validation for constraint: int
        if (!is_null($driverDoc) && !(is_int($driverDoc) || ctype_digit($driverDoc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($driverDoc, true), gettype($driverDoc)), __LINE__);
        }
        $this->driverDoc = $driverDoc;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\TripsAndPcounter
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get mDescription value
     * @return string|null
     */
    public function getMDescription()
    {
        return $this->mDescription;
    }
    /**
     * Set mDescription value
     * @param string $mDescription
     * @return \StructType\TripsAndPcounter
     */
    public function setMDescription($mDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mDescription) && !is_string($mDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mDescription, true), gettype($mDescription)), __LINE__);
        }
        $this->mDescription = $mDescription;
        return $this;
    }
    /**
     * Get dateTimeInit value
     * @return string|null
     */
    public function getDateTimeInit()
    {
        return $this->dateTimeInit;
    }
    /**
     * Set dateTimeInit value
     * @param string $dateTimeInit
     * @return \StructType\TripsAndPcounter
     */
    public function setDateTimeInit($dateTimeInit = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeInit) && !is_string($dateTimeInit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeInit, true), gettype($dateTimeInit)), __LINE__);
        }
        $this->dateTimeInit = $dateTimeInit;
        return $this;
    }
    /**
     * Get dateTimeEnd value
     * @return string|null
     */
    public function getDateTimeEnd()
    {
        return $this->dateTimeEnd;
    }
    /**
     * Set dateTimeEnd value
     * @param string $dateTimeEnd
     * @return \StructType\TripsAndPcounter
     */
    public function setDateTimeEnd($dateTimeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeEnd) && !is_string($dateTimeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeEnd, true), gettype($dateTimeEnd)), __LINE__);
        }
        $this->dateTimeEnd = $dateTimeEnd;
        return $this;
    }
    /**
     * Get driverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->driverName;
    }
    /**
     * Set driverName value
     * @param string $driverName
     * @return \StructType\TripsAndPcounter
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->driverName = $driverName;
        return $this;
    }
    /**
     * Get itDesc value
     * @return string|null
     */
    public function getItDesc()
    {
        return $this->itDesc;
    }
    /**
     * Set itDesc value
     * @param string $itDesc
     * @return \StructType\TripsAndPcounter
     */
    public function setItDesc($itDesc = null)
    {
        // validation for constraint: string
        if (!is_null($itDesc) && !is_string($itDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itDesc, true), gettype($itDesc)), __LINE__);
        }
        $this->itDesc = $itDesc;
        return $this;
    }
}
