<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TripsAndPcSummary StructType
 * @subpackage Structs
 */
class TripsAndPcSummary extends AbstractStructBase
{
    /**
     * The mTrips
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mTrips;
    /**
     * The mobilizedPassengers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $mobilizedPassengers;
    /**
     * The georeferencedPassengers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $georeferencedPassengers;
    /**
     * The passengersDifference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $passengersDifference;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The mDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mDescription;
    /**
     * The dateTimeInit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateTimeInit;
    /**
     * The dateTimeEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateTimeEnd;
    /**
     * The driverName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $driverName;
    /**
     * Constructor method for TripsAndPcSummary
     * @uses TripsAndPcSummary::setMTrips()
     * @uses TripsAndPcSummary::setMobilizedPassengers()
     * @uses TripsAndPcSummary::setGeoreferencedPassengers()
     * @uses TripsAndPcSummary::setPassengersDifference()
     * @uses TripsAndPcSummary::setMId()
     * @uses TripsAndPcSummary::setMDescription()
     * @uses TripsAndPcSummary::setDateTimeInit()
     * @uses TripsAndPcSummary::setDateTimeEnd()
     * @uses TripsAndPcSummary::setDriverName()
     * @param int $mTrips
     * @param int $mobilizedPassengers
     * @param int $georeferencedPassengers
     * @param int $passengersDifference
     * @param string $mId
     * @param string $mDescription
     * @param string $dateTimeInit
     * @param string $dateTimeEnd
     * @param string $driverName
     */
    public function __construct($mTrips = null, $mobilizedPassengers = null, $georeferencedPassengers = null, $passengersDifference = null, $mId = null, $mDescription = null, $dateTimeInit = null, $dateTimeEnd = null, $driverName = null)
    {
        $this
            ->setMTrips($mTrips)
            ->setMobilizedPassengers($mobilizedPassengers)
            ->setGeoreferencedPassengers($georeferencedPassengers)
            ->setPassengersDifference($passengersDifference)
            ->setMId($mId)
            ->setMDescription($mDescription)
            ->setDateTimeInit($dateTimeInit)
            ->setDateTimeEnd($dateTimeEnd)
            ->setDriverName($driverName);
    }
    /**
     * Get mTrips value
     * @return int
     */
    public function getMTrips()
    {
        return $this->mTrips;
    }
    /**
     * Set mTrips value
     * @param int $mTrips
     * @return \StructType\TripsAndPcSummary
     */
    public function setMTrips($mTrips = null)
    {
        // validation for constraint: int
        if (!is_null($mTrips) && !(is_int($mTrips) || ctype_digit($mTrips))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mTrips, true), gettype($mTrips)), __LINE__);
        }
        $this->mTrips = $mTrips;
        return $this;
    }
    /**
     * Get mobilizedPassengers value
     * @return int
     */
    public function getMobilizedPassengers()
    {
        return $this->mobilizedPassengers;
    }
    /**
     * Set mobilizedPassengers value
     * @param int $mobilizedPassengers
     * @return \StructType\TripsAndPcSummary
     */
    public function setMobilizedPassengers($mobilizedPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($mobilizedPassengers) && !(is_int($mobilizedPassengers) || ctype_digit($mobilizedPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mobilizedPassengers, true), gettype($mobilizedPassengers)), __LINE__);
        }
        $this->mobilizedPassengers = $mobilizedPassengers;
        return $this;
    }
    /**
     * Get georeferencedPassengers value
     * @return int
     */
    public function getGeoreferencedPassengers()
    {
        return $this->georeferencedPassengers;
    }
    /**
     * Set georeferencedPassengers value
     * @param int $georeferencedPassengers
     * @return \StructType\TripsAndPcSummary
     */
    public function setGeoreferencedPassengers($georeferencedPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($georeferencedPassengers) && !(is_int($georeferencedPassengers) || ctype_digit($georeferencedPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($georeferencedPassengers, true), gettype($georeferencedPassengers)), __LINE__);
        }
        $this->georeferencedPassengers = $georeferencedPassengers;
        return $this;
    }
    /**
     * Get passengersDifference value
     * @return int
     */
    public function getPassengersDifference()
    {
        return $this->passengersDifference;
    }
    /**
     * Set passengersDifference value
     * @param int $passengersDifference
     * @return \StructType\TripsAndPcSummary
     */
    public function setPassengersDifference($passengersDifference = null)
    {
        // validation for constraint: int
        if (!is_null($passengersDifference) && !(is_int($passengersDifference) || ctype_digit($passengersDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengersDifference, true), gettype($passengersDifference)), __LINE__);
        }
        $this->passengersDifference = $passengersDifference;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\TripsAndPcSummary
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get mDescription value
     * @return string|null
     */
    public function getMDescription()
    {
        return $this->mDescription;
    }
    /**
     * Set mDescription value
     * @param string $mDescription
     * @return \StructType\TripsAndPcSummary
     */
    public function setMDescription($mDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mDescription) && !is_string($mDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mDescription, true), gettype($mDescription)), __LINE__);
        }
        $this->mDescription = $mDescription;
        return $this;
    }
    /**
     * Get dateTimeInit value
     * @return string|null
     */
    public function getDateTimeInit()
    {
        return $this->dateTimeInit;
    }
    /**
     * Set dateTimeInit value
     * @param string $dateTimeInit
     * @return \StructType\TripsAndPcSummary
     */
    public function setDateTimeInit($dateTimeInit = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeInit) && !is_string($dateTimeInit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeInit, true), gettype($dateTimeInit)), __LINE__);
        }
        $this->dateTimeInit = $dateTimeInit;
        return $this;
    }
    /**
     * Get dateTimeEnd value
     * @return string|null
     */
    public function getDateTimeEnd()
    {
        return $this->dateTimeEnd;
    }
    /**
     * Set dateTimeEnd value
     * @param string $dateTimeEnd
     * @return \StructType\TripsAndPcSummary
     */
    public function setDateTimeEnd($dateTimeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeEnd) && !is_string($dateTimeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeEnd, true), gettype($dateTimeEnd)), __LINE__);
        }
        $this->dateTimeEnd = $dateTimeEnd;
        return $this;
    }
    /**
     * Get driverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->driverName;
    }
    /**
     * Set driverName value
     * @param string $driverName
     * @return \StructType\TripsAndPcSummary
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        $this->driverName = $driverName;
        return $this;
    }
}
