<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilteredGroup StructType
 * @subpackage Structs
 */
class FilteredGroup extends AbstractStructBase
{
    /**
     * The gId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gId;
    /**
     * The gName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gName;
    /**
     * The mIdList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $mIdList;
    /**
     * Constructor method for FilteredGroup
     * @uses FilteredGroup::setGId()
     * @uses FilteredGroup::setGName()
     * @uses FilteredGroup::setMIdList()
     * @param int $gId
     * @param string $gName
     * @param \ArrayType\ArrayOfString $mIdList
     */
    public function __construct($gId = null, $gName = null, \ArrayType\ArrayOfString $mIdList = null)
    {
        $this
            ->setGId($gId)
            ->setGName($gName)
            ->setMIdList($mIdList);
    }
    /**
     * Get gId value
     * @return int
     */
    public function getGId()
    {
        return $this->gId;
    }
    /**
     * Set gId value
     * @param int $gId
     * @return \StructType\FilteredGroup
     */
    public function setGId($gId = null)
    {
        // validation for constraint: int
        if (!is_null($gId) && !(is_int($gId) || ctype_digit($gId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gId, true), gettype($gId)), __LINE__);
        }
        $this->gId = $gId;
        return $this;
    }
    /**
     * Get gName value
     * @return string|null
     */
    public function getGName()
    {
        return $this->gName;
    }
    /**
     * Set gName value
     * @param string $gName
     * @return \StructType\FilteredGroup
     */
    public function setGName($gName = null)
    {
        // validation for constraint: string
        if (!is_null($gName) && !is_string($gName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gName, true), gettype($gName)), __LINE__);
        }
        $this->gName = $gName;
        return $this;
    }
    /**
     * Get mIdList value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getMIdList()
    {
        return $this->mIdList;
    }
    /**
     * Set mIdList value
     * @param \ArrayType\ArrayOfString $mIdList
     * @return \StructType\FilteredGroup
     */
    public function setMIdList(\ArrayType\ArrayOfString $mIdList = null)
    {
        $this->mIdList = $mIdList;
        return $this;
    }
}
