<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mobileSpecificationsInfo_Response StructType
 * @subpackage Structs
 */
class MobileSpecificationsInfo_Response extends AbstractStructBase
{
    /**
     * The error_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The specifications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Specifications
     */
    public $specifications;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for mobileSpecificationsInfo_Response
     * @uses MobileSpecificationsInfo_Response::setError_code()
     * @uses MobileSpecificationsInfo_Response::setSpecifications()
     * @uses MobileSpecificationsInfo_Response::setStatus()
     * @uses MobileSpecificationsInfo_Response::setDescription()
     * @param int $error_code
     * @param \StructType\Specifications $specifications
     * @param string $status
     * @param string $description
     */
    public function __construct($error_code = null, \StructType\Specifications $specifications = null, $status = null, $description = null)
    {
        $this
            ->setError_code($error_code)
            ->setSpecifications($specifications)
            ->setStatus($status)
            ->setDescription($description);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\MobileSpecificationsInfo_Response
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get specifications value
     * @return \StructType\Specifications
     */
    public function getSpecifications()
    {
        return $this->specifications;
    }
    /**
     * Set specifications value
     * @param \StructType\Specifications $specifications
     * @return \StructType\MobileSpecificationsInfo_Response
     */
    public function setSpecifications(\StructType\Specifications $specifications = null)
    {
        $this->specifications = $specifications;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\MobileSpecificationsInfo_Response
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MobileSpecificationsInfo_Response
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
