<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCounterLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfCounterLog extends AbstractStructArrayBase
{
    /**
     * The CounterLog
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CounterLog[]
     */
    public $CounterLog;
    /**
     * Constructor method for ArrayOfCounterLog
     * @uses ArrayOfCounterLog::setCounterLog()
     * @param \StructType\CounterLog[] $counterLog
     */
    public function __construct(array $counterLog = array())
    {
        $this
            ->setCounterLog($counterLog);
    }
    /**
     * Get CounterLog value
     * @return \StructType\CounterLog[]|null
     */
    public function getCounterLog()
    {
        return $this->CounterLog;
    }
    /**
     * This method is responsible for validating the values passed to the setCounterLog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCounterLog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCounterLogForArrayConstraintsFromSetCounterLog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCounterLogCounterLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfCounterLogCounterLogItem instanceof \StructType\CounterLog) {
                $invalidValues[] = is_object($arrayOfCounterLogCounterLogItem) ? get_class($arrayOfCounterLogCounterLogItem) : sprintf('%s(%s)', gettype($arrayOfCounterLogCounterLogItem), var_export($arrayOfCounterLogCounterLogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CounterLog property can only contain items of type \StructType\CounterLog, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CounterLog value
     * @throws \InvalidArgumentException
     * @param \StructType\CounterLog[] $counterLog
     * @return \ArrayType\ArrayOfCounterLog
     */
    public function setCounterLog(array $counterLog = array())
    {
        // validation for constraint: array
        if ('' !== ($counterLogArrayErrorMessage = self::validateCounterLogForArrayConstraintsFromSetCounterLog($counterLog))) {
            throw new \InvalidArgumentException($counterLogArrayErrorMessage, __LINE__);
        }
        $this->CounterLog = $counterLog;
        return $this;
    }
    /**
     * Add item to CounterLog value
     * @throws \InvalidArgumentException
     * @param \StructType\CounterLog $item
     * @return \ArrayType\ArrayOfCounterLog
     */
    public function addToCounterLog(\StructType\CounterLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CounterLog) {
            throw new \InvalidArgumentException(sprintf('The CounterLog property can only contain items of type \StructType\CounterLog, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CounterLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CounterLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CounterLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CounterLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CounterLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CounterLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CounterLog
     */
    public function getAttributeName()
    {
        return 'CounterLog';
    }
}
