<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get_1 extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Get_ADAS_events
     * Meta information extracted from the WSDL
     * - documentation: Obtiene los eventos ADAS de una lista de moviles y/o spns en un rango de fechas UTC en formato yyyy-mm-dd hh:mm:ss. Para incluir todos los spns y/o móviles deje su valor vacío.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_ADAS_events $parameters
     * @return \StructType\Get_ADAS_eventsResponse|bool
     */
    public function Get_ADAS_events(\StructType\Get_ADAS_events $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_ADAS_events($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_ADAS_events_totals
     * Meta information extracted from the WSDL
     * - documentation: Obtiene los totales de eventos ADAS de una lista de spns o móviles en un rango de fechas UTC en formato yyyy-mm-dd hh:mm:ss. Para incluir todos los spns y/o móviles deje su valor vacío.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_ADAS_events_totals $parameters
     * @return \StructType\Get_ADAS_events_totalsResponse|bool
     */
    public function Get_ADAS_events_totals(\StructType\Get_ADAS_events_totals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_ADAS_events_totals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_ADAS_eventsResponse|\StructType\Get_ADAS_events_totalsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
