<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GET ServiceType
 * @subpackage Services
 */
class GET extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_mobile_categories_info
     * Meta information extracted from the WSDL
     * - documentation: Obtiene las especificaciones de cada categoría asociadas a un móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_mobile_categories_info $parameters
     * @return \StructType\GET_mobile_categories_infoResponse|bool
     */
    public function GET_mobile_categories_info(\StructType\GET_mobile_categories_info $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_mobile_categories_info($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_mobile_categories_infoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
