<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileStatusLog StructType
 * @subpackage Structs
 */
class MobileStatusLog extends AbstractStructBase
{
    /**
     * The regId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $status;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The datetime_GMT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $datetime_GMT;
    /**
     * Constructor method for MobileStatusLog
     * @uses MobileStatusLog::setRegId()
     * @uses MobileStatusLog::setStatus()
     * @uses MobileStatusLog::setMId()
     * @uses MobileStatusLog::setUser()
     * @uses MobileStatusLog::setDatetime_GMT()
     * @param int $regId
     * @param int $status
     * @param string $mId
     * @param string $user
     * @param string $datetime_GMT
     */
    public function __construct($regId = null, $status = null, $mId = null, $user = null, $datetime_GMT = null)
    {
        $this
            ->setRegId($regId)
            ->setStatus($status)
            ->setMId($mId)
            ->setUser($user)
            ->setDatetime_GMT($datetime_GMT);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\MobileStatusLog
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\MobileStatusLog
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\MobileStatusLog
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\MobileStatusLog
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get datetime_GMT value
     * @return string|null
     */
    public function getDatetime_GMT()
    {
        return $this->datetime_GMT;
    }
    /**
     * Set datetime_GMT value
     * @param string $datetime_GMT
     * @return \StructType\MobileStatusLog
     */
    public function setDatetime_GMT($datetime_GMT = null)
    {
        // validation for constraint: string
        if (!is_null($datetime_GMT) && !is_string($datetime_GMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datetime_GMT, true), gettype($datetime_GMT)), __LINE__);
        }
        $this->datetime_GMT = $datetime_GMT;
        return $this;
    }
}
