<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileOperationInfoResponse StructType
 * @subpackage Structs
 */
class MobileOperationInfoResponse extends AbstractStructBase
{
    /**
     * The error_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $error_code;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mobilStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMobileOperationInfo
     */
    public $mobilStatus;
    /**
     * Constructor method for MobileOperationInfoResponse
     * @uses MobileOperationInfoResponse::setError_code()
     * @uses MobileOperationInfoResponse::setStatus()
     * @uses MobileOperationInfoResponse::setDescription()
     * @uses MobileOperationInfoResponse::setMobilStatus()
     * @param int $error_code
     * @param string $status
     * @param string $description
     * @param \ArrayType\ArrayOfMobileOperationInfo $mobilStatus
     */
    public function __construct($error_code = null, $status = null, $description = null, \ArrayType\ArrayOfMobileOperationInfo $mobilStatus = null)
    {
        $this
            ->setError_code($error_code)
            ->setStatus($status)
            ->setDescription($description)
            ->setMobilStatus($mobilStatus);
    }
    /**
     * Get error_code value
     * @return int
     */
    public function getError_code()
    {
        return $this->error_code;
    }
    /**
     * Set error_code value
     * @param int $error_code
     * @return \StructType\MobileOperationInfoResponse
     */
    public function setError_code($error_code = null)
    {
        // validation for constraint: int
        if (!is_null($error_code) && !(is_int($error_code) || ctype_digit($error_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($error_code, true), gettype($error_code)), __LINE__);
        }
        $this->error_code = $error_code;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\MobileOperationInfoResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MobileOperationInfoResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mobilStatus value
     * @return \ArrayType\ArrayOfMobileOperationInfo|null
     */
    public function getMobilStatus()
    {
        return $this->mobilStatus;
    }
    /**
     * Set mobilStatus value
     * @param \ArrayType\ArrayOfMobileOperationInfo $mobilStatus
     * @return \StructType\MobileOperationInfoResponse
     */
    public function setMobilStatus(\ArrayType\ArrayOfMobileOperationInfo $mobilStatus = null)
    {
        $this->mobilStatus = $mobilStatus;
        return $this;
    }
}
