<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GETT ServiceType
 * @subpackage Services
 */
class GETT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GET_TrackerOdometer
     * Meta information extracted from the WSDL
     * - documentation: Retorna el valor y última fecha de actualización del odómetro de un Móvil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TrackerOdometer $parameters
     * @return \StructType\GET_TrackerOdometerResponse|bool
     */
    public function GET_TrackerOdometer(\StructType\GET_TrackerOdometer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TrackerOdometer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GET_TripsAndPassengersSummary
     * Meta information extracted from the WSDL
     * - documentation: Obtiene el total de viajes y pasajeros de un vehículo dentro de un rango de fechas. UTC_datetime_Init y UTC_datetime_End se da en el formato yyyy-mm-dd hh:mm:ss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GET_TripsAndPassengersSummary $parameters
     * @return \StructType\GET_TripsAndPassengersSummaryResponse|bool
     */
    public function GET_TripsAndPassengersSummary(\StructType\GET_TripsAndPassengersSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GET_TripsAndPassengersSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GET_TrackerOdometerResponse|\StructType\GET_TripsAndPassengersSummaryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
