<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItLog ArrayType
 * @subpackage Arrays
 */
class ArrayOfItLog extends AbstractStructArrayBase
{
    /**
     * The ItLog
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItLog[]
     */
    public $ItLog;
    /**
     * Constructor method for ArrayOfItLog
     * @uses ArrayOfItLog::setItLog()
     * @param \StructType\ItLog[] $itLog
     */
    public function __construct(array $itLog = array())
    {
        $this
            ->setItLog($itLog);
    }
    /**
     * Get ItLog value
     * @return \StructType\ItLog[]|null
     */
    public function getItLog()
    {
        return $this->ItLog;
    }
    /**
     * This method is responsible for validating the values passed to the setItLog method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItLog method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItLogForArrayConstraintsFromSetItLog(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItLogItLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfItLogItLogItem instanceof \StructType\ItLog) {
                $invalidValues[] = is_object($arrayOfItLogItLogItem) ? get_class($arrayOfItLogItLogItem) : sprintf('%s(%s)', gettype($arrayOfItLogItLogItem), var_export($arrayOfItLogItLogItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItLog property can only contain items of type \StructType\ItLog, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItLog value
     * @throws \InvalidArgumentException
     * @param \StructType\ItLog[] $itLog
     * @return \ArrayType\ArrayOfItLog
     */
    public function setItLog(array $itLog = array())
    {
        // validation for constraint: array
        if ('' !== ($itLogArrayErrorMessage = self::validateItLogForArrayConstraintsFromSetItLog($itLog))) {
            throw new \InvalidArgumentException($itLogArrayErrorMessage, __LINE__);
        }
        $this->ItLog = $itLog;
        return $this;
    }
    /**
     * Add item to ItLog value
     * @throws \InvalidArgumentException
     * @param \StructType\ItLog $item
     * @return \ArrayType\ArrayOfItLog
     */
    public function addToItLog(\StructType\ItLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItLog) {
            throw new \InvalidArgumentException(sprintf('The ItLog property can only contain items of type \StructType\ItLog, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItLog
     */
    public function getAttributeName()
    {
        return 'ItLog';
    }
}
