<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_Route StructType
 * @subpackage Structs
 */
class Payments_Route extends AbstractStructBase
{
    /**
     * The ItineraryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItineraryId;
    /**
     * The RouteCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteCode;
    /**
     * The ItineraryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItineraryName;
    /**
     * Constructor method for Payments_Route
     * @uses Payments_Route::setItineraryId()
     * @uses Payments_Route::setRouteCode()
     * @uses Payments_Route::setItineraryName()
     * @param int $itineraryId
     * @param string $routeCode
     * @param string $itineraryName
     */
    public function __construct($itineraryId = null, $routeCode = null, $itineraryName = null)
    {
        $this
            ->setItineraryId($itineraryId)
            ->setRouteCode($routeCode)
            ->setItineraryName($itineraryName);
    }
    /**
     * Get ItineraryId value
     * @return int
     */
    public function getItineraryId()
    {
        return $this->ItineraryId;
    }
    /**
     * Set ItineraryId value
     * @param int $itineraryId
     * @return \StructType\Payments_Route
     */
    public function setItineraryId($itineraryId = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryId) && !(is_int($itineraryId) || ctype_digit($itineraryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itineraryId, true), gettype($itineraryId)), __LINE__);
        }
        $this->ItineraryId = $itineraryId;
        return $this;
    }
    /**
     * Get RouteCode value
     * @return string|null
     */
    public function getRouteCode()
    {
        return $this->RouteCode;
    }
    /**
     * Set RouteCode value
     * @param string $routeCode
     * @return \StructType\Payments_Route
     */
    public function setRouteCode($routeCode = null)
    {
        // validation for constraint: string
        if (!is_null($routeCode) && !is_string($routeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeCode, true), gettype($routeCode)), __LINE__);
        }
        $this->RouteCode = $routeCode;
        return $this;
    }
    /**
     * Get ItineraryName value
     * @return string|null
     */
    public function getItineraryName()
    {
        return $this->ItineraryName;
    }
    /**
     * Set ItineraryName value
     * @param string $itineraryName
     * @return \StructType\Payments_Route
     */
    public function setItineraryName($itineraryName = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryName) && !is_string($itineraryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itineraryName, true), gettype($itineraryName)), __LINE__);
        }
        $this->ItineraryName = $itineraryName;
        return $this;
    }
}
