<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CounterLog StructType
 * @subpackage Structs
 */
class CounterLog extends AbstractStructBase
{
    /**
     * The regId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regId;
    /**
     * The counterId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $counterId;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $value;
    /**
     * The mId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mId;
    /**
     * The gps_UTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gps_UTC;
    /**
     * The system_UTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $system_UTC;
    /**
     * Constructor method for CounterLog
     * @uses CounterLog::setRegId()
     * @uses CounterLog::setCounterId()
     * @uses CounterLog::setValue()
     * @uses CounterLog::setMId()
     * @uses CounterLog::setGps_UTC()
     * @uses CounterLog::setSystem_UTC()
     * @param int $regId
     * @param int $counterId
     * @param int $value
     * @param string $mId
     * @param string $gps_UTC
     * @param string $system_UTC
     */
    public function __construct($regId = null, $counterId = null, $value = null, $mId = null, $gps_UTC = null, $system_UTC = null)
    {
        $this
            ->setRegId($regId)
            ->setCounterId($counterId)
            ->setValue($value)
            ->setMId($mId)
            ->setGps_UTC($gps_UTC)
            ->setSystem_UTC($system_UTC);
    }
    /**
     * Get regId value
     * @return int
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \StructType\CounterLog
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: int
        if (!is_null($regId) && !(is_int($regId) || ctype_digit($regId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regId, true), gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get counterId value
     * @return int
     */
    public function getCounterId()
    {
        return $this->counterId;
    }
    /**
     * Set counterId value
     * @param int $counterId
     * @return \StructType\CounterLog
     */
    public function setCounterId($counterId = null)
    {
        // validation for constraint: int
        if (!is_null($counterId) && !(is_int($counterId) || ctype_digit($counterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($counterId, true), gettype($counterId)), __LINE__);
        }
        $this->counterId = $counterId;
        return $this;
    }
    /**
     * Get value value
     * @return int
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \StructType\CounterLog
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get mId value
     * @return string|null
     */
    public function getMId()
    {
        return $this->mId;
    }
    /**
     * Set mId value
     * @param string $mId
     * @return \StructType\CounterLog
     */
    public function setMId($mId = null)
    {
        // validation for constraint: string
        if (!is_null($mId) && !is_string($mId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mId, true), gettype($mId)), __LINE__);
        }
        $this->mId = $mId;
        return $this;
    }
    /**
     * Get gps_UTC value
     * @return string|null
     */
    public function getGps_UTC()
    {
        return $this->gps_UTC;
    }
    /**
     * Set gps_UTC value
     * @param string $gps_UTC
     * @return \StructType\CounterLog
     */
    public function setGps_UTC($gps_UTC = null)
    {
        // validation for constraint: string
        if (!is_null($gps_UTC) && !is_string($gps_UTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_UTC, true), gettype($gps_UTC)), __LINE__);
        }
        $this->gps_UTC = $gps_UTC;
        return $this;
    }
    /**
     * Get system_UTC value
     * @return string|null
     */
    public function getSystem_UTC()
    {
        return $this->system_UTC;
    }
    /**
     * Set system_UTC value
     * @param string $system_UTC
     * @return \StructType\CounterLog
     */
    public function setSystem_UTC($system_UTC = null)
    {
        // validation for constraint: string
        if (!is_null($system_UTC) && !is_string($system_UTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system_UTC, true), gettype($system_UTC)), __LINE__);
        }
        $this->system_UTC = $system_UTC;
        return $this;
    }
}
