<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_vehicle StructType
 * @subpackage Structs
 */
class Payments_vehicle extends AbstractStructBase
{
    /**
     * The VehicleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleId;
    /**
     * The VehicleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleDescription;
    /**
     * The VehiclePlate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehiclePlate;
    /**
     * Constructor method for Payments_vehicle
     * @uses Payments_vehicle::setVehicleId()
     * @uses Payments_vehicle::setVehicleDescription()
     * @uses Payments_vehicle::setVehiclePlate()
     * @param string $vehicleId
     * @param string $vehicleDescription
     * @param string $vehiclePlate
     */
    public function __construct($vehicleId = null, $vehicleDescription = null, $vehiclePlate = null)
    {
        $this
            ->setVehicleId($vehicleId)
            ->setVehicleDescription($vehicleDescription)
            ->setVehiclePlate($vehiclePlate);
    }
    /**
     * Get VehicleId value
     * @return string|null
     */
    public function getVehicleId()
    {
        return $this->VehicleId;
    }
    /**
     * Set VehicleId value
     * @param string $vehicleId
     * @return \StructType\Payments_vehicle
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleId) && !is_string($vehicleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->VehicleId = $vehicleId;
        return $this;
    }
    /**
     * Get VehicleDescription value
     * @return string|null
     */
    public function getVehicleDescription()
    {
        return $this->VehicleDescription;
    }
    /**
     * Set VehicleDescription value
     * @param string $vehicleDescription
     * @return \StructType\Payments_vehicle
     */
    public function setVehicleDescription($vehicleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleDescription) && !is_string($vehicleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleDescription, true), gettype($vehicleDescription)), __LINE__);
        }
        $this->VehicleDescription = $vehicleDescription;
        return $this;
    }
    /**
     * Get VehiclePlate value
     * @return string|null
     */
    public function getVehiclePlate()
    {
        return $this->VehiclePlate;
    }
    /**
     * Set VehiclePlate value
     * @param string $vehiclePlate
     * @return \StructType\Payments_vehicle
     */
    public function setVehiclePlate($vehiclePlate = null)
    {
        // validation for constraint: string
        if (!is_null($vehiclePlate) && !is_string($vehiclePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehiclePlate, true), gettype($vehiclePlate)), __LINE__);
        }
        $this->VehiclePlate = $vehiclePlate;
        return $this;
    }
}
