<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileInfo StructType
 * @subpackage Structs
 */
class MobileInfo extends AbstractStructBase
{
    /**
     * The mMobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Mobile
     */
    public $mMobile;
    /**
     * The mLastAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Address
     */
    public $mLastAddress;
    /**
     * The mDriver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Driver
     */
    public $mDriver;
    /**
     * The mGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMobileGroup
     */
    public $mGroups;
    /**
     * Constructor method for MobileInfo
     * @uses MobileInfo::setMMobile()
     * @uses MobileInfo::setMLastAddress()
     * @uses MobileInfo::setMDriver()
     * @uses MobileInfo::setMGroups()
     * @param \StructType\Mobile $mMobile
     * @param \StructType\Address $mLastAddress
     * @param \StructType\Driver $mDriver
     * @param \ArrayType\ArrayOfMobileGroup $mGroups
     */
    public function __construct(\StructType\Mobile $mMobile = null, \StructType\Address $mLastAddress = null, \StructType\Driver $mDriver = null, \ArrayType\ArrayOfMobileGroup $mGroups = null)
    {
        $this
            ->setMMobile($mMobile)
            ->setMLastAddress($mLastAddress)
            ->setMDriver($mDriver)
            ->setMGroups($mGroups);
    }
    /**
     * Get mMobile value
     * @return \StructType\Mobile
     */
    public function getMMobile()
    {
        return $this->mMobile;
    }
    /**
     * Set mMobile value
     * @param \StructType\Mobile $mMobile
     * @return \StructType\MobileInfo
     */
    public function setMMobile(\StructType\Mobile $mMobile = null)
    {
        $this->mMobile = $mMobile;
        return $this;
    }
    /**
     * Get mLastAddress value
     * @return \StructType\Address
     */
    public function getMLastAddress()
    {
        return $this->mLastAddress;
    }
    /**
     * Set mLastAddress value
     * @param \StructType\Address $mLastAddress
     * @return \StructType\MobileInfo
     */
    public function setMLastAddress(\StructType\Address $mLastAddress = null)
    {
        $this->mLastAddress = $mLastAddress;
        return $this;
    }
    /**
     * Get mDriver value
     * @return \StructType\Driver
     */
    public function getMDriver()
    {
        return $this->mDriver;
    }
    /**
     * Set mDriver value
     * @param \StructType\Driver $mDriver
     * @return \StructType\MobileInfo
     */
    public function setMDriver(\StructType\Driver $mDriver = null)
    {
        $this->mDriver = $mDriver;
        return $this;
    }
    /**
     * Get mGroups value
     * @return \ArrayType\ArrayOfMobileGroup|null
     */
    public function getMGroups()
    {
        return $this->mGroups;
    }
    /**
     * Set mGroups value
     * @param \ArrayType\ArrayOfMobileGroup $mGroups
     * @return \StructType\MobileInfo
     */
    public function setMGroups(\ArrayType\ArrayOfMobileGroup $mGroups = null)
    {
        $this->mGroups = $mGroups;
        return $this;
    }
}
