<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SENDQ ServiceType
 * @subpackage Services
 */
class SENDQ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SEND_QuickMessageCfg
     * Meta information extracted from the WSDL
     * - documentation: Envía al móvil la configuración de un mensaje rápido. Requiere que el móvil tenga un dispositivo que permita el envío de mensajes rápidos. El valor de QMsgId debe estar entre 200 y 399
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SEND_QuickMessageCfg $parameters
     * @return \StructType\SEND_QuickMessageCfgResponse|bool
     */
    public function SEND_QuickMessageCfg(\StructType\SEND_QuickMessageCfg $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SEND_QuickMessageCfg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SEND_QuickMessageCfgResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
