<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMobileGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfMobileGroup extends AbstractStructArrayBase
{
    /**
     * The MobileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MobileGroup[]
     */
    public $MobileGroup;
    /**
     * Constructor method for ArrayOfMobileGroup
     * @uses ArrayOfMobileGroup::setMobileGroup()
     * @param \StructType\MobileGroup[] $mobileGroup
     */
    public function __construct(array $mobileGroup = array())
    {
        $this
            ->setMobileGroup($mobileGroup);
    }
    /**
     * Get MobileGroup value
     * @return \StructType\MobileGroup[]|null
     */
    public function getMobileGroup()
    {
        return $this->MobileGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setMobileGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMobileGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMobileGroupForArrayConstraintsFromSetMobileGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMobileGroupMobileGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfMobileGroupMobileGroupItem instanceof \StructType\MobileGroup) {
                $invalidValues[] = is_object($arrayOfMobileGroupMobileGroupItem) ? get_class($arrayOfMobileGroupMobileGroupItem) : sprintf('%s(%s)', gettype($arrayOfMobileGroupMobileGroupItem), var_export($arrayOfMobileGroupMobileGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MobileGroup property can only contain items of type \StructType\MobileGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MobileGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGroup[] $mobileGroup
     * @return \ArrayType\ArrayOfMobileGroup
     */
    public function setMobileGroup(array $mobileGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($mobileGroupArrayErrorMessage = self::validateMobileGroupForArrayConstraintsFromSetMobileGroup($mobileGroup))) {
            throw new \InvalidArgumentException($mobileGroupArrayErrorMessage, __LINE__);
        }
        $this->MobileGroup = $mobileGroup;
        return $this;
    }
    /**
     * Add item to MobileGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\MobileGroup $item
     * @return \ArrayType\ArrayOfMobileGroup
     */
    public function addToMobileGroup(\StructType\MobileGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MobileGroup) {
            throw new \InvalidArgumentException(sprintf('The MobileGroup property can only contain items of type \StructType\MobileGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MobileGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MobileGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MobileGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MobileGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MobileGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MobileGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MobileGroup
     */
    public function getAttributeName()
    {
        return 'MobileGroup';
    }
}
