<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileGroup StructType
 * @subpackage Structs
 */
class MobileGroup extends AbstractStructBase
{
    /**
     * The gId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gId;
    /**
     * The gName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gName;
    /**
     * The mList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMobile
     */
    public $mList;
    /**
     * Constructor method for MobileGroup
     * @uses MobileGroup::setGId()
     * @uses MobileGroup::setGName()
     * @uses MobileGroup::setMList()
     * @param int $gId
     * @param string $gName
     * @param \ArrayType\ArrayOfMobile $mList
     */
    public function __construct($gId = null, $gName = null, \ArrayType\ArrayOfMobile $mList = null)
    {
        $this
            ->setGId($gId)
            ->setGName($gName)
            ->setMList($mList);
    }
    /**
     * Get gId value
     * @return int
     */
    public function getGId()
    {
        return $this->gId;
    }
    /**
     * Set gId value
     * @param int $gId
     * @return \StructType\MobileGroup
     */
    public function setGId($gId = null)
    {
        // validation for constraint: int
        if (!is_null($gId) && !(is_int($gId) || ctype_digit($gId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gId, true), gettype($gId)), __LINE__);
        }
        $this->gId = $gId;
        return $this;
    }
    /**
     * Get gName value
     * @return string|null
     */
    public function getGName()
    {
        return $this->gName;
    }
    /**
     * Set gName value
     * @param string $gName
     * @return \StructType\MobileGroup
     */
    public function setGName($gName = null)
    {
        // validation for constraint: string
        if (!is_null($gName) && !is_string($gName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gName, true), gettype($gName)), __LINE__);
        }
        $this->gName = $gName;
        return $this;
    }
    /**
     * Get mList value
     * @return \ArrayType\ArrayOfMobile|null
     */
    public function getMList()
    {
        return $this->mList;
    }
    /**
     * Set mList value
     * @param \ArrayType\ArrayOfMobile $mList
     * @return \StructType\MobileGroup
     */
    public function setMList(\ArrayType\ArrayOfMobile $mList = null)
    {
        $this->mList = $mList;
        return $this;
    }
}
