<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SETD ServiceType
 * @subpackage Services
 */
class SETD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SET_Driver
     * Meta information extracted from the WSDL
     * - documentation: Asigna un conductor a un móvil. Si solo se incluye el mId, se borra la asignación para este movil. Si solo se incluye el DrvId, se borra la asignación para este conductor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_Driver $parameters
     * @return \StructType\SET_DriverResponse|bool
     */
    public function SET_Driver(\StructType\SET_Driver $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_Driver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SET_DeleteDriver
     * Meta information extracted from the WSDL
     * - documentation: Se elimina un conductor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SET_DeleteDriver $parameters
     * @return \StructType\SET_DeleteDriverResponse|bool
     */
    public function SET_DeleteDriver(\StructType\SET_DeleteDriver $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SET_DeleteDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SET_DeleteDriverResponse|\StructType\SET_DriverResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
