<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payments_GetFleetVehicles StructType
 * @subpackage Structs
 */
class Payments_GetFleetVehicles extends AbstractStructBase
{
    /**
     * The fleetId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $fleetId;
    /**
     * The accessId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessId;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for Payments_GetFleetVehicles
     * @uses Payments_GetFleetVehicles::setFleetId()
     * @uses Payments_GetFleetVehicles::setAccessId()
     * @uses Payments_GetFleetVehicles::setAccessKey()
     * @param int $fleetId
     * @param string $accessId
     * @param string $accessKey
     */
    public function __construct($fleetId = null, $accessId = null, $accessKey = null)
    {
        $this
            ->setFleetId($fleetId)
            ->setAccessId($accessId)
            ->setAccessKey($accessKey);
    }
    /**
     * Get fleetId value
     * @return int
     */
    public function getFleetId()
    {
        return $this->fleetId;
    }
    /**
     * Set fleetId value
     * @param int $fleetId
     * @return \StructType\Payments_GetFleetVehicles
     */
    public function setFleetId($fleetId = null)
    {
        // validation for constraint: int
        if (!is_null($fleetId) && !(is_int($fleetId) || ctype_digit($fleetId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fleetId, true), gettype($fleetId)), __LINE__);
        }
        $this->fleetId = $fleetId;
        return $this;
    }
    /**
     * Get accessId value
     * @return string|null
     */
    public function getAccessId()
    {
        return $this->accessId;
    }
    /**
     * Set accessId value
     * @param string $accessId
     * @return \StructType\Payments_GetFleetVehicles
     */
    public function setAccessId($accessId = null)
    {
        // validation for constraint: string
        if (!is_null($accessId) && !is_string($accessId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessId, true), gettype($accessId)), __LINE__);
        }
        $this->accessId = $accessId;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\Payments_GetFleetVehicles
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
