<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Odometer StructType
 * @subpackage Structs
 */
class Odometer extends AbstractStructBase
{
    /**
     * The OdoCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OdoCount;
    /**
     * The Tracker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tracker;
    /**
     * The LastOdoDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastOdoDateTime;
    /**
     * Constructor method for Odometer
     * @uses Odometer::setOdoCount()
     * @uses Odometer::setTracker()
     * @uses Odometer::setLastOdoDateTime()
     * @param int $odoCount
     * @param string $tracker
     * @param string $lastOdoDateTime
     */
    public function __construct($odoCount = null, $tracker = null, $lastOdoDateTime = null)
    {
        $this
            ->setOdoCount($odoCount)
            ->setTracker($tracker)
            ->setLastOdoDateTime($lastOdoDateTime);
    }
    /**
     * Get OdoCount value
     * @return int
     */
    public function getOdoCount()
    {
        return $this->OdoCount;
    }
    /**
     * Set OdoCount value
     * @param int $odoCount
     * @return \StructType\Odometer
     */
    public function setOdoCount($odoCount = null)
    {
        // validation for constraint: int
        if (!is_null($odoCount) && !(is_int($odoCount) || ctype_digit($odoCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odoCount, true), gettype($odoCount)), __LINE__);
        }
        $this->OdoCount = $odoCount;
        return $this;
    }
    /**
     * Get Tracker value
     * @return string|null
     */
    public function getTracker()
    {
        return $this->Tracker;
    }
    /**
     * Set Tracker value
     * @param string $tracker
     * @return \StructType\Odometer
     */
    public function setTracker($tracker = null)
    {
        // validation for constraint: string
        if (!is_null($tracker) && !is_string($tracker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracker, true), gettype($tracker)), __LINE__);
        }
        $this->Tracker = $tracker;
        return $this;
    }
    /**
     * Get LastOdoDateTime value
     * @return string|null
     */
    public function getLastOdoDateTime()
    {
        return $this->LastOdoDateTime;
    }
    /**
     * Set LastOdoDateTime value
     * @param string $lastOdoDateTime
     * @return \StructType\Odometer
     */
    public function setLastOdoDateTime($lastOdoDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastOdoDateTime) && !is_string($lastOdoDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOdoDateTime, true), gettype($lastOdoDateTime)), __LINE__);
        }
        $this->LastOdoDateTime = $lastOdoDateTime;
        return $this;
    }
}
